/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig;
import software.amazon.awssdk.services.elasticsearch.transform.AccessPoliciesStatusUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.AdvancedOptionsStatusUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.EBSOptionsStatusUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ElasticsearchClusterConfigStatusUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ElasticsearchVersionStatusUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.LogPublishingOptionsStatusUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.SnapshotOptionsStatusUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.VPCDerivedInfoStatusUnmarshaller;

public class ElasticsearchDomainConfigUnmarshaller
implements Unmarshaller<ElasticsearchDomainConfig, JsonUnmarshallerContext> {
    private static final ElasticsearchDomainConfigUnmarshaller INSTANCE = new ElasticsearchDomainConfigUnmarshaller();

    public ElasticsearchDomainConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        ElasticsearchDomainConfig.Builder elasticsearchDomainConfigBuilder = ElasticsearchDomainConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ElasticsearchVersion", targetDepth)) {
                    context.nextToken();
                    elasticsearchDomainConfigBuilder.elasticsearchVersion(ElasticsearchVersionStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ElasticsearchClusterConfig", targetDepth)) {
                    context.nextToken();
                    elasticsearchDomainConfigBuilder.elasticsearchClusterConfig(ElasticsearchClusterConfigStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("EBSOptions", targetDepth)) {
                    context.nextToken();
                    elasticsearchDomainConfigBuilder.ebsOptions(EBSOptionsStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AccessPolicies", targetDepth)) {
                    context.nextToken();
                    elasticsearchDomainConfigBuilder.accessPolicies(AccessPoliciesStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SnapshotOptions", targetDepth)) {
                    context.nextToken();
                    elasticsearchDomainConfigBuilder.snapshotOptions(SnapshotOptionsStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("VPCOptions", targetDepth)) {
                    context.nextToken();
                    elasticsearchDomainConfigBuilder.vpcOptions(VPCDerivedInfoStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AdvancedOptions", targetDepth)) {
                    context.nextToken();
                    elasticsearchDomainConfigBuilder.advancedOptions(AdvancedOptionsStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LogPublishingOptions", targetDepth)) {
                    context.nextToken();
                    elasticsearchDomainConfigBuilder.logPublishingOptions(LogPublishingOptionsStatusUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ElasticsearchDomainConfig)elasticsearchDomainConfigBuilder.build();
    }

    public static ElasticsearchDomainConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

