/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig;

@SdkInternalApi
public class ElasticsearchDomainConfigMarshaller {
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchVersion").build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHCLUSTERCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchClusterConfig").build();
    private static final MarshallingInfo<StructuredPojo> EBSOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EBSOptions").build();
    private static final MarshallingInfo<StructuredPojo> ACCESSPOLICIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessPolicies").build();
    private static final MarshallingInfo<StructuredPojo> SNAPSHOTOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotOptions").build();
    private static final MarshallingInfo<StructuredPojo> VPCOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VPCOptions").build();
    private static final MarshallingInfo<StructuredPojo> ADVANCEDOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdvancedOptions").build();
    private static final MarshallingInfo<StructuredPojo> LOGPUBLISHINGOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogPublishingOptions").build();
    private static final ElasticsearchDomainConfigMarshaller INSTANCE = new ElasticsearchDomainConfigMarshaller();

    public static ElasticsearchDomainConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchDomainConfig elasticsearchDomainConfig, ProtocolMarshaller protocolMarshaller) {
        if (elasticsearchDomainConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.elasticsearchVersion(), ELASTICSEARCHVERSION_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.elasticsearchClusterConfig(), ELASTICSEARCHCLUSTERCONFIG_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.ebsOptions(), EBSOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.accessPolicies(), ACCESSPOLICIES_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.snapshotOptions(), SNAPSHOTOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.vpcOptions(), VPCOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.advancedOptions(), ADVANCEDOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.logPublishingOptions(), LOGPUBLISHINGOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

