/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse;

public final class ListElasticsearchInstanceTypesPaginator
implements SdkIterable<ListElasticsearchInstanceTypesResponse> {
    private final ElasticsearchClient client;
    private final ListElasticsearchInstanceTypesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListElasticsearchInstanceTypesPaginator(ElasticsearchClient client, ListElasticsearchInstanceTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListElasticsearchInstanceTypesResponseFetcher();
    }

    public Iterator<ListElasticsearchInstanceTypesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListElasticsearchInstanceTypesResponseFetcher
    implements NextPageFetcher<ListElasticsearchInstanceTypesResponse> {
        private ListElasticsearchInstanceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListElasticsearchInstanceTypesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListElasticsearchInstanceTypesResponse nextPage(ListElasticsearchInstanceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListElasticsearchInstanceTypesPaginator.this.client.listElasticsearchInstanceTypes(ListElasticsearchInstanceTypesPaginator.this.firstRequest);
            }
            return ListElasticsearchInstanceTypesPaginator.this.client.listElasticsearchInstanceTypes((ListElasticsearchInstanceTypesRequest)((Object)ListElasticsearchInstanceTypesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

