/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListElasticsearchVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListElasticsearchVersionsResponse> {
    private final List<String> elasticsearchVersions;
    private final String nextToken;

    private ListElasticsearchVersionsResponse(BuilderImpl builder) {
        this.elasticsearchVersions = builder.elasticsearchVersions;
        this.nextToken = builder.nextToken;
    }

    public List<String> elasticsearchVersions() {
        return this.elasticsearchVersions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListElasticsearchVersionsResponse)) {
            return false;
        }
        ListElasticsearchVersionsResponse other = (ListElasticsearchVersionsResponse)((Object)obj);
        return Objects.equals(this.elasticsearchVersions(), other.elasticsearchVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.elasticsearchVersions() != null) {
            sb.append("ElasticsearchVersions: ").append(this.elasticsearchVersions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticsearchVersions": {
                return Optional.of(clazz.cast(this.elasticsearchVersions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> elasticsearchVersions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListElasticsearchVersionsResponse model) {
            this.elasticsearchVersions(model.elasticsearchVersions);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getElasticsearchVersions() {
            return this.elasticsearchVersions;
        }

        @Override
        public final Builder elasticsearchVersions(Collection<String> elasticsearchVersions) {
            this.elasticsearchVersions = ElasticsearchVersionListCopier.copy(elasticsearchVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticsearchVersions(String ... elasticsearchVersions) {
            this.elasticsearchVersions(Arrays.asList(elasticsearchVersions));
            return this;
        }

        public final void setElasticsearchVersions(Collection<String> elasticsearchVersions) {
            this.elasticsearchVersions = ElasticsearchVersionListCopier.copy(elasticsearchVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListElasticsearchVersionsResponse build() {
            return new ListElasticsearchVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListElasticsearchVersionsResponse> {
        public Builder elasticsearchVersions(Collection<String> var1);

        public Builder elasticsearchVersions(String ... var1);

        public Builder nextToken(String var1);
    }
}

