/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.AccessPoliciesStatus;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfigStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionStatus;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.SnapshotOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfoStatus;
import software.amazon.awssdk.services.elasticsearch.transform.ElasticsearchDomainConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticsearchDomainConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchDomainConfig> {
    private final ElasticsearchVersionStatus elasticsearchVersion;
    private final ElasticsearchClusterConfigStatus elasticsearchClusterConfig;
    private final EBSOptionsStatus ebsOptions;
    private final AccessPoliciesStatus accessPolicies;
    private final SnapshotOptionsStatus snapshotOptions;
    private final VPCDerivedInfoStatus vpcOptions;
    private final AdvancedOptionsStatus advancedOptions;
    private final LogPublishingOptionsStatus logPublishingOptions;

    private ElasticsearchDomainConfig(BuilderImpl builder) {
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
    }

    public ElasticsearchVersionStatus elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public ElasticsearchClusterConfigStatus elasticsearchClusterConfig() {
        return this.elasticsearchClusterConfig;
    }

    public EBSOptionsStatus ebsOptions() {
        return this.ebsOptions;
    }

    public AccessPoliciesStatus accessPolicies() {
        return this.accessPolicies;
    }

    public SnapshotOptionsStatus snapshotOptions() {
        return this.snapshotOptions;
    }

    public VPCDerivedInfoStatus vpcOptions() {
        return this.vpcOptions;
    }

    public AdvancedOptionsStatus advancedOptions() {
        return this.advancedOptions;
    }

    public LogPublishingOptionsStatus logPublishingOptions() {
        return this.logPublishingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchClusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDomainConfig)) {
            return false;
        }
        ElasticsearchDomainConfig other = (ElasticsearchDomainConfig)obj;
        return Objects.equals(this.elasticsearchVersion(), other.elasticsearchVersion()) && Objects.equals(this.elasticsearchClusterConfig(), other.elasticsearchClusterConfig()) && Objects.equals(this.ebsOptions(), other.ebsOptions()) && Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.snapshotOptions(), other.snapshotOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.advancedOptions(), other.advancedOptions()) && Objects.equals(this.logPublishingOptions(), other.logPublishingOptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.elasticsearchVersion() != null) {
            sb.append("ElasticsearchVersion: ").append(this.elasticsearchVersion()).append(",");
        }
        if (this.elasticsearchClusterConfig() != null) {
            sb.append("ElasticsearchClusterConfig: ").append(this.elasticsearchClusterConfig()).append(",");
        }
        if (this.ebsOptions() != null) {
            sb.append("EBSOptions: ").append(this.ebsOptions()).append(",");
        }
        if (this.accessPolicies() != null) {
            sb.append("AccessPolicies: ").append(this.accessPolicies()).append(",");
        }
        if (this.snapshotOptions() != null) {
            sb.append("SnapshotOptions: ").append(this.snapshotOptions()).append(",");
        }
        if (this.vpcOptions() != null) {
            sb.append("VPCOptions: ").append(this.vpcOptions()).append(",");
        }
        if (this.advancedOptions() != null) {
            sb.append("AdvancedOptions: ").append(this.advancedOptions()).append(",");
        }
        if (this.logPublishingOptions() != null) {
            sb.append("LogPublishingOptions: ").append(this.logPublishingOptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticsearchVersion": {
                return Optional.of(clazz.cast(this.elasticsearchVersion()));
            }
            case "ElasticsearchClusterConfig": {
                return Optional.of(clazz.cast(this.elasticsearchClusterConfig()));
            }
            case "EBSOptions": {
                return Optional.of(clazz.cast(this.ebsOptions()));
            }
            case "AccessPolicies": {
                return Optional.of(clazz.cast(this.accessPolicies()));
            }
            case "SnapshotOptions": {
                return Optional.of(clazz.cast(this.snapshotOptions()));
            }
            case "VPCOptions": {
                return Optional.of(clazz.cast(this.vpcOptions()));
            }
            case "AdvancedOptions": {
                return Optional.of(clazz.cast(this.advancedOptions()));
            }
            case "LogPublishingOptions": {
                return Optional.of(clazz.cast(this.logPublishingOptions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchDomainConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ElasticsearchVersionStatus elasticsearchVersion;
        private ElasticsearchClusterConfigStatus elasticsearchClusterConfig;
        private EBSOptionsStatus ebsOptions;
        private AccessPoliciesStatus accessPolicies;
        private SnapshotOptionsStatus snapshotOptions;
        private VPCDerivedInfoStatus vpcOptions;
        private AdvancedOptionsStatus advancedOptions;
        private LogPublishingOptionsStatus logPublishingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDomainConfig model) {
            this.elasticsearchVersion(model.elasticsearchVersion);
            this.elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.accessPolicies(model.accessPolicies);
            this.snapshotOptions(model.snapshotOptions);
            this.vpcOptions(model.vpcOptions);
            this.advancedOptions(model.advancedOptions);
            this.logPublishingOptions(model.logPublishingOptions);
        }

        public final ElasticsearchVersionStatus.Builder getElasticsearchVersion() {
            return this.elasticsearchVersion != null ? this.elasticsearchVersion.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchVersion(ElasticsearchVersionStatus elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(ElasticsearchVersionStatus.BuilderImpl elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion != null ? elasticsearchVersion.build() : null;
        }

        public final ElasticsearchClusterConfigStatus.Builder getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig != null ? this.elasticsearchClusterConfig.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchClusterConfig(ElasticsearchClusterConfigStatus elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final void setElasticsearchClusterConfig(ElasticsearchClusterConfigStatus.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        public final EBSOptionsStatus.Builder getEBSOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptionsStatus ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final void setEBSOptions(EBSOptionsStatus.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        public final AccessPoliciesStatus.Builder getAccessPolicies() {
            return this.accessPolicies != null ? this.accessPolicies.toBuilder() : null;
        }

        @Override
        public final Builder accessPolicies(AccessPoliciesStatus accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(AccessPoliciesStatus.BuilderImpl accessPolicies) {
            this.accessPolicies = accessPolicies != null ? accessPolicies.build() : null;
        }

        public final SnapshotOptionsStatus.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptionsStatus snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final void setSnapshotOptions(SnapshotOptionsStatus.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        public final VPCDerivedInfoStatus.Builder getVPCOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        @Override
        public final Builder vpcOptions(VPCDerivedInfoStatus vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final void setVPCOptions(VPCDerivedInfoStatus.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        public final AdvancedOptionsStatus.Builder getAdvancedOptions() {
            return this.advancedOptions != null ? this.advancedOptions.toBuilder() : null;
        }

        @Override
        public final Builder advancedOptions(AdvancedOptionsStatus advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        public final void setAdvancedOptions(AdvancedOptionsStatus.BuilderImpl advancedOptions) {
            this.advancedOptions = advancedOptions != null ? advancedOptions.build() : null;
        }

        public final LogPublishingOptionsStatus.Builder getLogPublishingOptions() {
            return this.logPublishingOptions != null ? this.logPublishingOptions.toBuilder() : null;
        }

        @Override
        public final Builder logPublishingOptions(LogPublishingOptionsStatus logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final void setLogPublishingOptions(LogPublishingOptionsStatus.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        public ElasticsearchDomainConfig build() {
            return new ElasticsearchDomainConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchDomainConfig> {
        public Builder elasticsearchVersion(ElasticsearchVersionStatus var1);

        default public Builder elasticsearchVersion(Consumer<ElasticsearchVersionStatus.Builder> elasticsearchVersion) {
            return this.elasticsearchVersion((ElasticsearchVersionStatus)((ElasticsearchVersionStatus.Builder)ElasticsearchVersionStatus.builder().apply(elasticsearchVersion)).build());
        }

        public Builder elasticsearchClusterConfig(ElasticsearchClusterConfigStatus var1);

        default public Builder elasticsearchClusterConfig(Consumer<ElasticsearchClusterConfigStatus.Builder> elasticsearchClusterConfig) {
            return this.elasticsearchClusterConfig((ElasticsearchClusterConfigStatus)((ElasticsearchClusterConfigStatus.Builder)ElasticsearchClusterConfigStatus.builder().apply(elasticsearchClusterConfig)).build());
        }

        public Builder ebsOptions(EBSOptionsStatus var1);

        default public Builder ebsOptions(Consumer<EBSOptionsStatus.Builder> ebsOptions) {
            return this.ebsOptions((EBSOptionsStatus)((EBSOptionsStatus.Builder)EBSOptionsStatus.builder().apply(ebsOptions)).build());
        }

        public Builder accessPolicies(AccessPoliciesStatus var1);

        default public Builder accessPolicies(Consumer<AccessPoliciesStatus.Builder> accessPolicies) {
            return this.accessPolicies((AccessPoliciesStatus)((AccessPoliciesStatus.Builder)AccessPoliciesStatus.builder().apply(accessPolicies)).build());
        }

        public Builder snapshotOptions(SnapshotOptionsStatus var1);

        default public Builder snapshotOptions(Consumer<SnapshotOptionsStatus.Builder> snapshotOptions) {
            return this.snapshotOptions((SnapshotOptionsStatus)((SnapshotOptionsStatus.Builder)SnapshotOptionsStatus.builder().apply(snapshotOptions)).build());
        }

        public Builder vpcOptions(VPCDerivedInfoStatus var1);

        default public Builder vpcOptions(Consumer<VPCDerivedInfoStatus.Builder> vpcOptions) {
            return this.vpcOptions((VPCDerivedInfoStatus)((VPCDerivedInfoStatus.Builder)VPCDerivedInfoStatus.builder().apply(vpcOptions)).build());
        }

        public Builder advancedOptions(AdvancedOptionsStatus var1);

        default public Builder advancedOptions(Consumer<AdvancedOptionsStatus.Builder> advancedOptions) {
            return this.advancedOptions((AdvancedOptionsStatus)((AdvancedOptionsStatus.Builder)AdvancedOptionsStatus.builder().apply(advancedOptions)).build());
        }

        public Builder logPublishingOptions(LogPublishingOptionsStatus var1);

        default public Builder logPublishingOptions(Consumer<LogPublishingOptionsStatus.Builder> logPublishingOptions) {
            return this.logPublishingOptions((LogPublishingOptionsStatus)((LogPublishingOptionsStatus.Builder)LogPublishingOptionsStatus.builder().apply(logPublishingOptions)).build());
        }
    }
}

