/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.VolumeType;
import software.amazon.awssdk.services.elasticsearch.transform.EBSOptionsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EBSOptions
implements StructuredPojo,
ToCopyableBuilder<Builder, EBSOptions> {
    private final Boolean ebsEnabled;
    private final String volumeType;
    private final Integer volumeSize;
    private final Integer iops;

    private EBSOptions(BuilderImpl builder) {
        this.ebsEnabled = builder.ebsEnabled;
        this.volumeType = builder.volumeType;
        this.volumeSize = builder.volumeSize;
        this.iops = builder.iops;
    }

    public Boolean ebsEnabled() {
        return this.ebsEnabled;
    }

    public VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public String volumeTypeString() {
        return this.volumeType;
    }

    public Integer volumeSize() {
        return this.volumeSize;
    }

    public Integer iops() {
        return this.iops;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EBSOptions)) {
            return false;
        }
        EBSOptions other = (EBSOptions)obj;
        return Objects.equals(this.ebsEnabled(), other.ebsEnabled()) && Objects.equals(this.volumeTypeString(), other.volumeTypeString()) && Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.iops(), other.iops());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ebsEnabled() != null) {
            sb.append("EBSEnabled: ").append(this.ebsEnabled()).append(",");
        }
        if (this.volumeTypeString() != null) {
            sb.append("VolumeType: ").append(this.volumeTypeString()).append(",");
        }
        if (this.volumeSize() != null) {
            sb.append("VolumeSize: ").append(this.volumeSize()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EBSEnabled": {
                return Optional.of(clazz.cast(this.ebsEnabled()));
            }
            case "VolumeType": {
                return Optional.of(clazz.cast(this.volumeTypeString()));
            }
            case "VolumeSize": {
                return Optional.of(clazz.cast(this.volumeSize()));
            }
            case "Iops": {
                return Optional.of(clazz.cast(this.iops()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EBSOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean ebsEnabled;
        private String volumeType;
        private Integer volumeSize;
        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(EBSOptions model) {
            this.ebsEnabled(model.ebsEnabled);
            this.volumeType(model.volumeType);
            this.volumeSize(model.volumeSize);
            this.iops(model.iops);
        }

        public final Boolean getEBSEnabled() {
            return this.ebsEnabled;
        }

        @Override
        public final Builder ebsEnabled(Boolean ebsEnabled) {
            this.ebsEnabled = ebsEnabled;
            return this;
        }

        public final void setEBSEnabled(Boolean ebsEnabled) {
            this.ebsEnabled = ebsEnabled;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public EBSOptions build() {
            return new EBSOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EBSOptions> {
        public Builder ebsEnabled(Boolean var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);

        public Builder volumeSize(Integer var1);

        public Builder iops(Integer var1);
    }
}

