/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.OptionStatus;
import software.amazon.awssdk.services.elasticsearch.transform.ElasticsearchVersionStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticsearchVersionStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchVersionStatus> {
    private final String options;
    private final OptionStatus status;

    private ElasticsearchVersionStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    public String options() {
        return this.options;
    }

    public OptionStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.options() == null ? 0 : this.options().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchVersionStatus)) {
            return false;
        }
        ElasticsearchVersionStatus other = (ElasticsearchVersionStatus)obj;
        if (other.options() == null ^ this.options() == null) {
            return false;
        }
        if (other.options() != null && !other.options().equals(this.options())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.options() != null) {
            sb.append("Options: ").append(this.options()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Options": {
                return Optional.of(clazz.cast(this.options()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchVersionStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String options;
        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchVersionStatus model) {
            this.options(model.options);
            this.status(model.status);
        }

        public final String getOptions() {
            return this.options;
        }

        @Override
        public final Builder options(String options) {
            this.options = options;
            return this;
        }

        public final void setOptions(String options) {
            this.options = options;
        }

        public final OptionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(OptionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public ElasticsearchVersionStatus build() {
            return new ElasticsearchVersionStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchVersionStatus> {
        public Builder options(String var1);

        public Builder status(OptionStatus var1);
    }
}

