/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatusListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticsearchDomainsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeElasticsearchDomainsResponse> {
    private final List<ElasticsearchDomainStatus> domainStatusList;

    private DescribeElasticsearchDomainsResponse(BuilderImpl builder) {
        this.domainStatusList = builder.domainStatusList;
    }

    public List<ElasticsearchDomainStatus> domainStatusList() {
        return this.domainStatusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainStatusList() == null ? 0 : this.domainStatusList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchDomainsResponse)) {
            return false;
        }
        DescribeElasticsearchDomainsResponse other = (DescribeElasticsearchDomainsResponse)((Object)obj);
        if (other.domainStatusList() == null ^ this.domainStatusList() == null) {
            return false;
        }
        return other.domainStatusList() == null || other.domainStatusList().equals(this.domainStatusList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainStatusList() != null) {
            sb.append("DomainStatusList: ").append(this.domainStatusList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainStatusList": {
                return Optional.of(clazz.cast(this.domainStatusList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ElasticsearchDomainStatus> domainStatusList;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchDomainsResponse model) {
            this.domainStatusList(model.domainStatusList);
        }

        public final Collection<ElasticsearchDomainStatus.Builder> getDomainStatusList() {
            return this.domainStatusList != null ? (Collection)this.domainStatusList.stream().map(ElasticsearchDomainStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainStatusList(Collection<ElasticsearchDomainStatus> domainStatusList) {
            this.domainStatusList = ElasticsearchDomainStatusListCopier.copy(domainStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(ElasticsearchDomainStatus ... domainStatusList) {
            this.domainStatusList(Arrays.asList(domainStatusList));
            return this;
        }

        public final void setDomainStatusList(Collection<ElasticsearchDomainStatus.BuilderImpl> domainStatusList) {
            this.domainStatusList = ElasticsearchDomainStatusListCopier.copyFromBuilder(domainStatusList);
        }

        public DescribeElasticsearchDomainsResponse build() {
            return new DescribeElasticsearchDomainsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeElasticsearchDomainsResponse> {
        public Builder domainStatusList(Collection<ElasticsearchDomainStatus> var1);

        public Builder domainStatusList(ElasticsearchDomainStatus ... var1);
    }
}

