/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticsearch.model.Tag;
import software.amazon.awssdk.services.elasticsearch.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddTagsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddTagsRequest> {
    private final String arn;
    private final List<Tag> tagList;

    private AddTagsRequest(BuilderImpl builder) {
        this.arn = builder.arn;
        this.tagList = builder.tagList;
    }

    public String arn() {
        return this.arn;
    }

    public List<Tag> tagList() {
        return this.tagList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.tagList() == null ? 0 : this.tagList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsRequest)) {
            return false;
        }
        AddTagsRequest other = (AddTagsRequest)((Object)obj);
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.tagList() == null ^ this.tagList() == null) {
            return false;
        }
        return other.tagList() == null || other.tagList().equals(this.tagList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.arn() != null) {
            sb.append("ARN: ").append(this.arn()).append(",");
        }
        if (this.tagList() != null) {
            sb.append("TagList: ").append(this.tagList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ARN": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "TagList": {
                return Optional.of(clazz.cast(this.tagList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<Tag> tagList;

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsRequest model) {
            this.arn(model.arn);
            this.tagList(model.tagList);
        }

        public final String getARN() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final Collection<Tag.Builder> getTagList() {
            return this.tagList != null ? (Collection)this.tagList.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        public AddTagsRequest build() {
            return new AddTagsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddTagsRequest> {
        public Builder arn(String var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);
    }
}

