/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticsearch.model.ESPartitionInstanceType;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchInstanceTypeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListElasticsearchInstanceTypesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListElasticsearchInstanceTypesResponse> {
    private final List<String> elasticsearchInstanceTypes;
    private final String nextToken;

    private ListElasticsearchInstanceTypesResponse(BuilderImpl builder) {
        this.elasticsearchInstanceTypes = builder.elasticsearchInstanceTypes;
        this.nextToken = builder.nextToken;
    }

    public List<String> elasticsearchInstanceTypes() {
        return this.elasticsearchInstanceTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.elasticsearchInstanceTypes() == null ? 0 : this.elasticsearchInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListElasticsearchInstanceTypesResponse)) {
            return false;
        }
        ListElasticsearchInstanceTypesResponse other = (ListElasticsearchInstanceTypesResponse)((Object)obj);
        if (other.elasticsearchInstanceTypes() == null ^ this.elasticsearchInstanceTypes() == null) {
            return false;
        }
        if (other.elasticsearchInstanceTypes() != null && !other.elasticsearchInstanceTypes().equals(this.elasticsearchInstanceTypes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.elasticsearchInstanceTypes() != null) {
            sb.append("ElasticsearchInstanceTypes: ").append(this.elasticsearchInstanceTypes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> elasticsearchInstanceTypes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListElasticsearchInstanceTypesResponse model) {
            this.setElasticsearchInstanceTypes(model.elasticsearchInstanceTypes);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getElasticsearchInstanceTypes() {
            return this.elasticsearchInstanceTypes;
        }

        @Override
        public final Builder elasticsearchInstanceTypes(Collection<String> elasticsearchInstanceTypes) {
            this.elasticsearchInstanceTypes = ElasticsearchInstanceTypeListCopier.copy(elasticsearchInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticsearchInstanceTypes(String ... elasticsearchInstanceTypes) {
            this.elasticsearchInstanceTypes(Arrays.asList(elasticsearchInstanceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticsearchInstanceTypes(ESPartitionInstanceType ... elasticsearchInstanceTypes) {
            this.elasticsearchInstanceTypes(Arrays.asList(elasticsearchInstanceTypes).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticsearchInstanceTypes(Collection<String> elasticsearchInstanceTypes) {
            this.elasticsearchInstanceTypes = ElasticsearchInstanceTypeListCopier.copy(elasticsearchInstanceTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListElasticsearchInstanceTypesResponse build() {
            return new ListElasticsearchInstanceTypesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListElasticsearchInstanceTypesResponse> {
        public Builder elasticsearchInstanceTypes(Collection<String> var1);

        public Builder elasticsearchInstanceTypes(String ... var1);

        public Builder elasticsearchInstanceTypes(ESPartitionInstanceType ... var1);

        public Builder nextToken(String var1);
    }
}

