/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.OptionStatus;

@SdkInternalApi
public class OptionStatusMarshaller {
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").build();
    private static final MarshallingInfo<Instant> UPDATEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateDate").build();
    private static final MarshallingInfo<Integer> UPDATEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateVersion").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<Boolean> PENDINGDELETION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PendingDeletion").build();
    private static final OptionStatusMarshaller instance = new OptionStatusMarshaller();

    public static OptionStatusMarshaller getInstance() {
        return instance;
    }

    public void marshall(OptionStatus optionStatus, ProtocolMarshaller protocolMarshaller) {
        if (optionStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)optionStatus.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)optionStatus.updateDate(), UPDATEDATE_BINDING);
            protocolMarshaller.marshall((Object)optionStatus.updateVersion(), UPDATEVERSION_BINDING);
            protocolMarshaller.marshall((Object)optionStatus.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)optionStatus.pendingDeletion(), PENDINGDELETION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

