/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.Limits;
import software.amazon.awssdk.services.elasticsearch.transform.AdditionalLimitUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.InstanceLimitsUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.StorageTypeUnmarshaller;

public class LimitsUnmarshaller
implements Unmarshaller<Limits, JsonUnmarshallerContext> {
    private static LimitsUnmarshaller INSTANCE;

    public Limits unmarshall(JsonUnmarshallerContext context) throws Exception {
        Limits.Builder limitsBuilder = Limits.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("StorageTypes", targetDepth)) {
                    context.nextToken();
                    limitsBuilder.storageTypes(new ListUnmarshaller((Unmarshaller)StorageTypeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("InstanceLimits", targetDepth)) {
                    context.nextToken();
                    limitsBuilder.instanceLimits(InstanceLimitsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AdditionalLimits", targetDepth)) {
                    context.nextToken();
                    limitsBuilder.additionalLimits(new ListUnmarshaller((Unmarshaller)AdditionalLimitUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Limits)limitsBuilder.build();
    }

    public static LimitsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LimitsUnmarshaller();
        }
        return INSTANCE;
    }
}

