/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionAuthenticationRequestExtraParamsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticateCognitoActionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticateCognitoActionConfig> {
    private static final SdkField<String> USER_POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthenticateCognitoActionConfig.getter(AuthenticateCognitoActionConfig::userPoolArn)).setter(AuthenticateCognitoActionConfig.setter(Builder::userPoolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolArn").build()}).build();
    private static final SdkField<String> USER_POOL_CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthenticateCognitoActionConfig.getter(AuthenticateCognitoActionConfig::userPoolClientId)).setter(AuthenticateCognitoActionConfig.setter(Builder::userPoolClientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolClientId").build()}).build();
    private static final SdkField<String> USER_POOL_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthenticateCognitoActionConfig.getter(AuthenticateCognitoActionConfig::userPoolDomain)).setter(AuthenticateCognitoActionConfig.setter(Builder::userPoolDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolDomain").build()}).build();
    private static final SdkField<String> SESSION_COOKIE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthenticateCognitoActionConfig.getter(AuthenticateCognitoActionConfig::sessionCookieName)).setter(AuthenticateCognitoActionConfig.setter(Builder::sessionCookieName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionCookieName").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthenticateCognitoActionConfig.getter(AuthenticateCognitoActionConfig::scope)).setter(AuthenticateCognitoActionConfig.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<Long> SESSION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AuthenticateCognitoActionConfig.getter(AuthenticateCognitoActionConfig::sessionTimeout)).setter(AuthenticateCognitoActionConfig.setter(Builder::sessionTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeout").build()}).build();
    private static final SdkField<Map<String, String>> AUTHENTICATION_REQUEST_EXTRA_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AuthenticateCognitoActionConfig.getter(AuthenticateCognitoActionConfig::authenticationRequestExtraParams)).setter(AuthenticateCognitoActionConfig.setter(Builder::authenticationRequestExtraParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationRequestExtraParams").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ON_UNAUTHENTICATED_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthenticateCognitoActionConfig.getter(AuthenticateCognitoActionConfig::onUnauthenticatedRequestAsString)).setter(AuthenticateCognitoActionConfig.setter(Builder::onUnauthenticatedRequest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnUnauthenticatedRequest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ARN_FIELD, USER_POOL_CLIENT_ID_FIELD, USER_POOL_DOMAIN_FIELD, SESSION_COOKIE_NAME_FIELD, SCOPE_FIELD, SESSION_TIMEOUT_FIELD, AUTHENTICATION_REQUEST_EXTRA_PARAMS_FIELD, ON_UNAUTHENTICATED_REQUEST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userPoolArn;
    private final String userPoolClientId;
    private final String userPoolDomain;
    private final String sessionCookieName;
    private final String scope;
    private final Long sessionTimeout;
    private final Map<String, String> authenticationRequestExtraParams;
    private final String onUnauthenticatedRequest;

    private AuthenticateCognitoActionConfig(BuilderImpl builder) {
        this.userPoolArn = builder.userPoolArn;
        this.userPoolClientId = builder.userPoolClientId;
        this.userPoolDomain = builder.userPoolDomain;
        this.sessionCookieName = builder.sessionCookieName;
        this.scope = builder.scope;
        this.sessionTimeout = builder.sessionTimeout;
        this.authenticationRequestExtraParams = builder.authenticationRequestExtraParams;
        this.onUnauthenticatedRequest = builder.onUnauthenticatedRequest;
    }

    public String userPoolArn() {
        return this.userPoolArn;
    }

    public String userPoolClientId() {
        return this.userPoolClientId;
    }

    public String userPoolDomain() {
        return this.userPoolDomain;
    }

    public String sessionCookieName() {
        return this.sessionCookieName;
    }

    public String scope() {
        return this.scope;
    }

    public Long sessionTimeout() {
        return this.sessionTimeout;
    }

    public Map<String, String> authenticationRequestExtraParams() {
        return this.authenticationRequestExtraParams;
    }

    public AuthenticateCognitoActionConditionalBehaviorEnum onUnauthenticatedRequest() {
        return AuthenticateCognitoActionConditionalBehaviorEnum.fromValue(this.onUnauthenticatedRequest);
    }

    public String onUnauthenticatedRequestAsString() {
        return this.onUnauthenticatedRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolClientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionCookieName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationRequestExtraParams());
        hashCode = 31 * hashCode + Objects.hashCode(this.onUnauthenticatedRequestAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticateCognitoActionConfig)) {
            return false;
        }
        AuthenticateCognitoActionConfig other = (AuthenticateCognitoActionConfig)obj;
        return Objects.equals(this.userPoolArn(), other.userPoolArn()) && Objects.equals(this.userPoolClientId(), other.userPoolClientId()) && Objects.equals(this.userPoolDomain(), other.userPoolDomain()) && Objects.equals(this.sessionCookieName(), other.sessionCookieName()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.sessionTimeout(), other.sessionTimeout()) && Objects.equals(this.authenticationRequestExtraParams(), other.authenticationRequestExtraParams()) && Objects.equals(this.onUnauthenticatedRequestAsString(), other.onUnauthenticatedRequestAsString());
    }

    public String toString() {
        return ToString.builder((String)"AuthenticateCognitoActionConfig").add("UserPoolArn", (Object)this.userPoolArn()).add("UserPoolClientId", (Object)this.userPoolClientId()).add("UserPoolDomain", (Object)this.userPoolDomain()).add("SessionCookieName", (Object)this.sessionCookieName()).add("Scope", (Object)this.scope()).add("SessionTimeout", (Object)this.sessionTimeout()).add("AuthenticationRequestExtraParams", this.authenticationRequestExtraParams()).add("OnUnauthenticatedRequest", (Object)this.onUnauthenticatedRequestAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolArn": {
                return Optional.ofNullable(clazz.cast(this.userPoolArn()));
            }
            case "UserPoolClientId": {
                return Optional.ofNullable(clazz.cast(this.userPoolClientId()));
            }
            case "UserPoolDomain": {
                return Optional.ofNullable(clazz.cast(this.userPoolDomain()));
            }
            case "SessionCookieName": {
                return Optional.ofNullable(clazz.cast(this.sessionCookieName()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "SessionTimeout": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeout()));
            }
            case "AuthenticationRequestExtraParams": {
                return Optional.ofNullable(clazz.cast(this.authenticationRequestExtraParams()));
            }
            case "OnUnauthenticatedRequest": {
                return Optional.ofNullable(clazz.cast(this.onUnauthenticatedRequestAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticateCognitoActionConfig, T> g) {
        return obj -> g.apply((AuthenticateCognitoActionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolArn;
        private String userPoolClientId;
        private String userPoolDomain;
        private String sessionCookieName;
        private String scope;
        private Long sessionTimeout;
        private Map<String, String> authenticationRequestExtraParams = DefaultSdkAutoConstructMap.getInstance();
        private String onUnauthenticatedRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticateCognitoActionConfig model) {
            this.userPoolArn(model.userPoolArn);
            this.userPoolClientId(model.userPoolClientId);
            this.userPoolDomain(model.userPoolDomain);
            this.sessionCookieName(model.sessionCookieName);
            this.scope(model.scope);
            this.sessionTimeout(model.sessionTimeout);
            this.authenticationRequestExtraParams(model.authenticationRequestExtraParams);
            this.onUnauthenticatedRequest(model.onUnauthenticatedRequest);
        }

        public final String getUserPoolArn() {
            return this.userPoolArn;
        }

        @Override
        public final Builder userPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
            return this;
        }

        public final void setUserPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
        }

        public final String getUserPoolClientId() {
            return this.userPoolClientId;
        }

        @Override
        public final Builder userPoolClientId(String userPoolClientId) {
            this.userPoolClientId = userPoolClientId;
            return this;
        }

        public final void setUserPoolClientId(String userPoolClientId) {
            this.userPoolClientId = userPoolClientId;
        }

        public final String getUserPoolDomain() {
            return this.userPoolDomain;
        }

        @Override
        public final Builder userPoolDomain(String userPoolDomain) {
            this.userPoolDomain = userPoolDomain;
            return this;
        }

        public final void setUserPoolDomain(String userPoolDomain) {
            this.userPoolDomain = userPoolDomain;
        }

        public final String getSessionCookieName() {
            return this.sessionCookieName;
        }

        @Override
        public final Builder sessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
            return this;
        }

        public final void setSessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
        }

        public final String getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Long getSessionTimeout() {
            return this.sessionTimeout;
        }

        @Override
        public final Builder sessionTimeout(Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public final void setSessionTimeout(Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        public final Map<String, String> getAuthenticationRequestExtraParams() {
            return this.authenticationRequestExtraParams;
        }

        @Override
        public final Builder authenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticateCognitoActionAuthenticationRequestExtraParamsCopier.copy(authenticationRequestExtraParams);
            return this;
        }

        public final void setAuthenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticateCognitoActionAuthenticationRequestExtraParamsCopier.copy(authenticationRequestExtraParams);
        }

        public final String getOnUnauthenticatedRequestAsString() {
            return this.onUnauthenticatedRequest;
        }

        @Override
        public final Builder onUnauthenticatedRequest(String onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
            return this;
        }

        @Override
        public final Builder onUnauthenticatedRequest(AuthenticateCognitoActionConditionalBehaviorEnum onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest(onUnauthenticatedRequest.toString());
            return this;
        }

        public final void setOnUnauthenticatedRequest(String onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
        }

        public AuthenticateCognitoActionConfig build() {
            return new AuthenticateCognitoActionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticateCognitoActionConfig> {
        public Builder userPoolArn(String var1);

        public Builder userPoolClientId(String var1);

        public Builder userPoolDomain(String var1);

        public Builder sessionCookieName(String var1);

        public Builder scope(String var1);

        public Builder sessionTimeout(Long var1);

        public Builder authenticationRequestExtraParams(Map<String, String> var1);

        public Builder onUnauthenticatedRequest(String var1);

        public Builder onUnauthenticatedRequest(AuthenticateCognitoActionConditionalBehaviorEnum var1);
    }
}

