/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProtocolEnum {
    HTTP("HTTP"),
    HTTPS("HTTPS"),
    TCP("TCP"),
    TLS("TLS"),
    UDP("UDP"),
    TCP_UDP("TCP_UDP"),
    GENEVE("GENEVE"),
    QUIC("QUIC"),
    TCP_QUIC("TCP_QUIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProtocolEnum> VALUE_MAP;
    private final String value;

    private ProtocolEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProtocolEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProtocolEnum> knownValues() {
        EnumSet<ProtocolEnum> knownValues = EnumSet.allOf(ProtocolEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProtocolEnum.class, ProtocolEnum::toString);
    }
}

