/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreAssociation;

public class DescribeTrustStoreAssociationsPublisher
implements SdkPublisher<DescribeTrustStoreAssociationsResponse> {
    private final ElasticLoadBalancingV2AsyncClient client;
    private final DescribeTrustStoreAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTrustStoreAssociationsPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeTrustStoreAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTrustStoreAssociationsPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeTrustStoreAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTrustStoreAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTrustStoreAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrustStoreAssociation> trustStoreAssociations() {
        return this.flatMapIterable(response -> response.trustStoreAssociations());
    }

    private class DescribeTrustStoreAssociationsResponseFetcher
    implements AsyncPageFetcher<DescribeTrustStoreAssociationsResponse> {
        private DescribeTrustStoreAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrustStoreAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<DescribeTrustStoreAssociationsResponse> nextPage(DescribeTrustStoreAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrustStoreAssociationsPublisher.this.client.describeTrustStoreAssociations(DescribeTrustStoreAssociationsPublisher.this.firstRequest);
            }
            return DescribeTrustStoreAssociationsPublisher.this.client.describeTrustStoreAssociations((DescribeTrustStoreAssociationsRequest)((Object)DescribeTrustStoreAssociationsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

