/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HostHeaderConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ListOfStringCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.PathPatternConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SourceIpConditionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleCondition> {
    private static final SdkField<String> FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Field").getter(RuleCondition.getter(RuleCondition::field)).setter(RuleCondition.setter(Builder::field)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(RuleCondition.getter(RuleCondition::values)).setter(RuleCondition.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HostHeaderConditionConfig> HOST_HEADER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HostHeaderConfig").getter(RuleCondition.getter(RuleCondition::hostHeaderConfig)).setter(RuleCondition.setter(Builder::hostHeaderConfig)).constructor(HostHeaderConditionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostHeaderConfig").build()}).build();
    private static final SdkField<PathPatternConditionConfig> PATH_PATTERN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PathPatternConfig").getter(RuleCondition.getter(RuleCondition::pathPatternConfig)).setter(RuleCondition.setter(Builder::pathPatternConfig)).constructor(PathPatternConditionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathPatternConfig").build()}).build();
    private static final SdkField<HttpHeaderConditionConfig> HTTP_HEADER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HttpHeaderConfig").getter(RuleCondition.getter(RuleCondition::httpHeaderConfig)).setter(RuleCondition.setter(Builder::httpHeaderConfig)).constructor(HttpHeaderConditionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpHeaderConfig").build()}).build();
    private static final SdkField<QueryStringConditionConfig> QUERY_STRING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryStringConfig").getter(RuleCondition.getter(RuleCondition::queryStringConfig)).setter(RuleCondition.setter(Builder::queryStringConfig)).constructor(QueryStringConditionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStringConfig").build()}).build();
    private static final SdkField<HttpRequestMethodConditionConfig> HTTP_REQUEST_METHOD_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HttpRequestMethodConfig").getter(RuleCondition.getter(RuleCondition::httpRequestMethodConfig)).setter(RuleCondition.setter(Builder::httpRequestMethodConfig)).constructor(HttpRequestMethodConditionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpRequestMethodConfig").build()}).build();
    private static final SdkField<SourceIpConditionConfig> SOURCE_IP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceIpConfig").getter(RuleCondition.getter(RuleCondition::sourceIpConfig)).setter(RuleCondition.setter(Builder::sourceIpConfig)).constructor(SourceIpConditionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpConfig").build()}).build();
    private static final SdkField<List<String>> REGEX_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegexValues").getter(RuleCondition.getter(RuleCondition::regexValues)).setter(RuleCondition.setter(Builder::regexValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, VALUES_FIELD, HOST_HEADER_CONFIG_FIELD, PATH_PATTERN_CONFIG_FIELD, HTTP_HEADER_CONFIG_FIELD, QUERY_STRING_CONFIG_FIELD, HTTP_REQUEST_METHOD_CONFIG_FIELD, SOURCE_IP_CONFIG_FIELD, REGEX_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String field;
    private final List<String> values;
    private final HostHeaderConditionConfig hostHeaderConfig;
    private final PathPatternConditionConfig pathPatternConfig;
    private final HttpHeaderConditionConfig httpHeaderConfig;
    private final QueryStringConditionConfig queryStringConfig;
    private final HttpRequestMethodConditionConfig httpRequestMethodConfig;
    private final SourceIpConditionConfig sourceIpConfig;
    private final List<String> regexValues;

    private RuleCondition(BuilderImpl builder) {
        this.field = builder.field;
        this.values = builder.values;
        this.hostHeaderConfig = builder.hostHeaderConfig;
        this.pathPatternConfig = builder.pathPatternConfig;
        this.httpHeaderConfig = builder.httpHeaderConfig;
        this.queryStringConfig = builder.queryStringConfig;
        this.httpRequestMethodConfig = builder.httpRequestMethodConfig;
        this.sourceIpConfig = builder.sourceIpConfig;
        this.regexValues = builder.regexValues;
    }

    public final String field() {
        return this.field;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public final HostHeaderConditionConfig hostHeaderConfig() {
        return this.hostHeaderConfig;
    }

    public final PathPatternConditionConfig pathPatternConfig() {
        return this.pathPatternConfig;
    }

    public final HttpHeaderConditionConfig httpHeaderConfig() {
        return this.httpHeaderConfig;
    }

    public final QueryStringConditionConfig queryStringConfig() {
        return this.queryStringConfig;
    }

    public final HttpRequestMethodConditionConfig httpRequestMethodConfig() {
        return this.httpRequestMethodConfig;
    }

    public final SourceIpConditionConfig sourceIpConfig() {
        return this.sourceIpConfig;
    }

    public final boolean hasRegexValues() {
        return this.regexValues != null && !(this.regexValues instanceof SdkAutoConstructList);
    }

    public final List<String> regexValues() {
        return this.regexValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.field());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hostHeaderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathPatternConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpHeaderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStringConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpRequestMethodConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegexValues() ? this.regexValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleCondition)) {
            return false;
        }
        RuleCondition other = (RuleCondition)obj;
        return Objects.equals(this.field(), other.field()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && Objects.equals(this.hostHeaderConfig(), other.hostHeaderConfig()) && Objects.equals(this.pathPatternConfig(), other.pathPatternConfig()) && Objects.equals(this.httpHeaderConfig(), other.httpHeaderConfig()) && Objects.equals(this.queryStringConfig(), other.queryStringConfig()) && Objects.equals(this.httpRequestMethodConfig(), other.httpRequestMethodConfig()) && Objects.equals(this.sourceIpConfig(), other.sourceIpConfig()) && this.hasRegexValues() == other.hasRegexValues() && Objects.equals(this.regexValues(), other.regexValues());
    }

    public final String toString() {
        return ToString.builder((String)"RuleCondition").add("Field", (Object)this.field()).add("Values", this.hasValues() ? this.values() : null).add("HostHeaderConfig", (Object)this.hostHeaderConfig()).add("PathPatternConfig", (Object)this.pathPatternConfig()).add("HttpHeaderConfig", (Object)this.httpHeaderConfig()).add("QueryStringConfig", (Object)this.queryStringConfig()).add("HttpRequestMethodConfig", (Object)this.httpRequestMethodConfig()).add("SourceIpConfig", (Object)this.sourceIpConfig()).add("RegexValues", this.hasRegexValues() ? this.regexValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Field": {
                return Optional.ofNullable(clazz.cast(this.field()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "HostHeaderConfig": {
                return Optional.ofNullable(clazz.cast(this.hostHeaderConfig()));
            }
            case "PathPatternConfig": {
                return Optional.ofNullable(clazz.cast(this.pathPatternConfig()));
            }
            case "HttpHeaderConfig": {
                return Optional.ofNullable(clazz.cast(this.httpHeaderConfig()));
            }
            case "QueryStringConfig": {
                return Optional.ofNullable(clazz.cast(this.queryStringConfig()));
            }
            case "HttpRequestMethodConfig": {
                return Optional.ofNullable(clazz.cast(this.httpRequestMethodConfig()));
            }
            case "SourceIpConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceIpConfig()));
            }
            case "RegexValues": {
                return Optional.ofNullable(clazz.cast(this.regexValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Field", FIELD_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("HostHeaderConfig", HOST_HEADER_CONFIG_FIELD);
        map.put("PathPatternConfig", PATH_PATTERN_CONFIG_FIELD);
        map.put("HttpHeaderConfig", HTTP_HEADER_CONFIG_FIELD);
        map.put("QueryStringConfig", QUERY_STRING_CONFIG_FIELD);
        map.put("HttpRequestMethodConfig", HTTP_REQUEST_METHOD_CONFIG_FIELD);
        map.put("SourceIpConfig", SOURCE_IP_CONFIG_FIELD);
        map.put("RegexValues", REGEX_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleCondition, T> g) {
        return obj -> g.apply((RuleCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String field;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private HostHeaderConditionConfig hostHeaderConfig;
        private PathPatternConditionConfig pathPatternConfig;
        private HttpHeaderConditionConfig httpHeaderConfig;
        private QueryStringConditionConfig queryStringConfig;
        private HttpRequestMethodConditionConfig httpRequestMethodConfig;
        private SourceIpConditionConfig sourceIpConfig;
        private List<String> regexValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleCondition model) {
            this.field(model.field);
            this.values(model.values);
            this.hostHeaderConfig(model.hostHeaderConfig);
            this.pathPatternConfig(model.pathPatternConfig);
            this.httpHeaderConfig(model.httpHeaderConfig);
            this.queryStringConfig(model.queryStringConfig);
            this.httpRequestMethodConfig(model.httpRequestMethodConfig);
            this.sourceIpConfig(model.sourceIpConfig);
            this.regexValues(model.regexValues);
        }

        public final String getField() {
            return this.field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final HostHeaderConditionConfig.Builder getHostHeaderConfig() {
            return this.hostHeaderConfig != null ? this.hostHeaderConfig.toBuilder() : null;
        }

        public final void setHostHeaderConfig(HostHeaderConditionConfig.BuilderImpl hostHeaderConfig) {
            this.hostHeaderConfig = hostHeaderConfig != null ? hostHeaderConfig.build() : null;
        }

        @Override
        public final Builder hostHeaderConfig(HostHeaderConditionConfig hostHeaderConfig) {
            this.hostHeaderConfig = hostHeaderConfig;
            return this;
        }

        public final PathPatternConditionConfig.Builder getPathPatternConfig() {
            return this.pathPatternConfig != null ? this.pathPatternConfig.toBuilder() : null;
        }

        public final void setPathPatternConfig(PathPatternConditionConfig.BuilderImpl pathPatternConfig) {
            this.pathPatternConfig = pathPatternConfig != null ? pathPatternConfig.build() : null;
        }

        @Override
        public final Builder pathPatternConfig(PathPatternConditionConfig pathPatternConfig) {
            this.pathPatternConfig = pathPatternConfig;
            return this;
        }

        public final HttpHeaderConditionConfig.Builder getHttpHeaderConfig() {
            return this.httpHeaderConfig != null ? this.httpHeaderConfig.toBuilder() : null;
        }

        public final void setHttpHeaderConfig(HttpHeaderConditionConfig.BuilderImpl httpHeaderConfig) {
            this.httpHeaderConfig = httpHeaderConfig != null ? httpHeaderConfig.build() : null;
        }

        @Override
        public final Builder httpHeaderConfig(HttpHeaderConditionConfig httpHeaderConfig) {
            this.httpHeaderConfig = httpHeaderConfig;
            return this;
        }

        public final QueryStringConditionConfig.Builder getQueryStringConfig() {
            return this.queryStringConfig != null ? this.queryStringConfig.toBuilder() : null;
        }

        public final void setQueryStringConfig(QueryStringConditionConfig.BuilderImpl queryStringConfig) {
            this.queryStringConfig = queryStringConfig != null ? queryStringConfig.build() : null;
        }

        @Override
        public final Builder queryStringConfig(QueryStringConditionConfig queryStringConfig) {
            this.queryStringConfig = queryStringConfig;
            return this;
        }

        public final HttpRequestMethodConditionConfig.Builder getHttpRequestMethodConfig() {
            return this.httpRequestMethodConfig != null ? this.httpRequestMethodConfig.toBuilder() : null;
        }

        public final void setHttpRequestMethodConfig(HttpRequestMethodConditionConfig.BuilderImpl httpRequestMethodConfig) {
            this.httpRequestMethodConfig = httpRequestMethodConfig != null ? httpRequestMethodConfig.build() : null;
        }

        @Override
        public final Builder httpRequestMethodConfig(HttpRequestMethodConditionConfig httpRequestMethodConfig) {
            this.httpRequestMethodConfig = httpRequestMethodConfig;
            return this;
        }

        public final SourceIpConditionConfig.Builder getSourceIpConfig() {
            return this.sourceIpConfig != null ? this.sourceIpConfig.toBuilder() : null;
        }

        public final void setSourceIpConfig(SourceIpConditionConfig.BuilderImpl sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig != null ? sourceIpConfig.build() : null;
        }

        @Override
        public final Builder sourceIpConfig(SourceIpConditionConfig sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig;
            return this;
        }

        public final Collection<String> getRegexValues() {
            if (this.regexValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regexValues;
        }

        public final void setRegexValues(Collection<String> regexValues) {
            this.regexValues = ListOfStringCopier.copy(regexValues);
        }

        @Override
        public final Builder regexValues(Collection<String> regexValues) {
            this.regexValues = ListOfStringCopier.copy(regexValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexValues(String ... regexValues) {
            this.regexValues(Arrays.asList(regexValues));
            return this;
        }

        public RuleCondition build() {
            return new RuleCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleCondition> {
        public Builder field(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder hostHeaderConfig(HostHeaderConditionConfig var1);

        default public Builder hostHeaderConfig(Consumer<HostHeaderConditionConfig.Builder> hostHeaderConfig) {
            return this.hostHeaderConfig((HostHeaderConditionConfig)((HostHeaderConditionConfig.Builder)HostHeaderConditionConfig.builder().applyMutation(hostHeaderConfig)).build());
        }

        public Builder pathPatternConfig(PathPatternConditionConfig var1);

        default public Builder pathPatternConfig(Consumer<PathPatternConditionConfig.Builder> pathPatternConfig) {
            return this.pathPatternConfig((PathPatternConditionConfig)((PathPatternConditionConfig.Builder)PathPatternConditionConfig.builder().applyMutation(pathPatternConfig)).build());
        }

        public Builder httpHeaderConfig(HttpHeaderConditionConfig var1);

        default public Builder httpHeaderConfig(Consumer<HttpHeaderConditionConfig.Builder> httpHeaderConfig) {
            return this.httpHeaderConfig((HttpHeaderConditionConfig)((HttpHeaderConditionConfig.Builder)HttpHeaderConditionConfig.builder().applyMutation(httpHeaderConfig)).build());
        }

        public Builder queryStringConfig(QueryStringConditionConfig var1);

        default public Builder queryStringConfig(Consumer<QueryStringConditionConfig.Builder> queryStringConfig) {
            return this.queryStringConfig((QueryStringConditionConfig)((QueryStringConditionConfig.Builder)QueryStringConditionConfig.builder().applyMutation(queryStringConfig)).build());
        }

        public Builder httpRequestMethodConfig(HttpRequestMethodConditionConfig var1);

        default public Builder httpRequestMethodConfig(Consumer<HttpRequestMethodConditionConfig.Builder> httpRequestMethodConfig) {
            return this.httpRequestMethodConfig((HttpRequestMethodConditionConfig)((HttpRequestMethodConditionConfig.Builder)HttpRequestMethodConditionConfig.builder().applyMutation(httpRequestMethodConfig)).build());
        }

        public Builder sourceIpConfig(SourceIpConditionConfig var1);

        default public Builder sourceIpConfig(Consumer<SourceIpConditionConfig.Builder> sourceIpConfig) {
            return this.sourceIpConfig((SourceIpConditionConfig)((SourceIpConditionConfig.Builder)SourceIpConditionConfig.builder().applyMutation(sourceIpConfig)).build());
        }

        public Builder regexValues(Collection<String> var1);

        public Builder regexValues(String ... var1);
    }
}

