/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup;

public class DescribeTargetGroupsPublisher
implements SdkPublisher<DescribeTargetGroupsResponse> {
    private final ElasticLoadBalancingV2AsyncClient client;
    private final DescribeTargetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTargetGroupsPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeTargetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTargetGroupsPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeTargetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTargetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTargetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TargetGroup> targetGroups() {
        return this.flatMapIterable(response -> response.targetGroups());
    }

    private class DescribeTargetGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeTargetGroupsResponse> {
        private DescribeTargetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTargetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<DescribeTargetGroupsResponse> nextPage(DescribeTargetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTargetGroupsPublisher.this.client.describeTargetGroups(DescribeTargetGroupsPublisher.this.firstRequest);
            }
            return DescribeTargetGroupsPublisher.this.client.describeTargetGroups((DescribeTargetGroupsRequest)((Object)DescribeTargetGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

