/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTrustStoreRevocationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTrustStoreRevocationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTrustStoreRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTrustStoreResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteSharedTrustStoreAssociationRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteSharedTrustStoreAssociationResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTrustStoreRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTrustStoreResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeCapacityReservationRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeCapacityReservationResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreCaCertificatesBundleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreCaCertificatesBundleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreRevocationContentRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreRevocationContentResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyCapacityReservationRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyCapacityReservationResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyIpPoolsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyIpPoolsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTrustStoreRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTrustStoreResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTrustStoreRevocationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTrustStoreRevocationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeAccountLimitsPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenerCertificatesPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeRulesPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoreAssociationsPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoreRevocationsPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoresPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.ElasticLoadBalancingV2AsyncWaiter;

/**
 * Service client for accessing Elastic Load Balancing v2 asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <fullname>Elastic Load Balancing</fullname>
 * <p>
 * A load balancer distributes incoming traffic across targets, such as your EC2 instances. This enables you to increase
 * the availability of your application. The load balancer also monitors the health of its registered targets and
 * ensures that it routes traffic only to healthy targets. You configure your load balancer to accept incoming traffic
 * by specifying one or more listeners, which are configured with a protocol and port number for connections from
 * clients to the load balancer. You configure a target group with a protocol and port number for connections from the
 * load balancer to the targets, and with health check settings to be used when checking the health status of the
 * targets.
 * </p>
 * <p>
 * Elastic Load Balancing supports the following types of load balancers: Application Load Balancers, Network Load
 * Balancers, Gateway Load Balancers, and Classic Load Balancers. This reference covers the following load balancer
 * types:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS.
 * </p>
 * </li>
 * <li>
 * <p>
 * Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, UDP, and QUIC.
 * </p>
 * </li>
 * <li>
 * <p>
 * Gateway Load Balancer - Operates at the network layer (layer 3).
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/">Elastic
 * Load Balancing User Guide</a>.
 * </p>
 * <p>
 * All Elastic Load Balancing operations are idempotent, which means that they complete at most one time. If you repeat
 * an operation, it succeeds.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ElasticLoadBalancingV2AsyncClient extends AwsClient {
    String SERVICE_NAME = "elasticloadbalancing";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "elasticloadbalancing";

    /**
     * <p>
     * Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the certificate in already in the certificate list, the call is successful but the certificate is not added
     * again.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/https-listener-certificates.html">SSL
     * certificates</a> in the <i>Application Load Balancers Guide</i> or <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/tls-listener-certificates.html">Server
     * certificates</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param addListenerCertificatesRequest
     * @return A Java Future containing the result of the AddListenerCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>TooManyCertificatesException You've reached the limit on the number of certificates per load
     *         balancer.</li>
     *         <li>CertificateNotFoundException The specified certificate does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.AddListenerCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddListenerCertificatesResponse> addListenerCertificates(
            AddListenerCertificatesRequest addListenerCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the certificate in already in the certificate list, the call is successful but the certificate is not added
     * again.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/https-listener-certificates.html">SSL
     * certificates</a> in the <i>Application Load Balancers Guide</i> or <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/tls-listener-certificates.html">Server
     * certificates</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddListenerCertificatesRequest.Builder} avoiding
     * the need to create one manually via {@link AddListenerCertificatesRequest#builder()}
     * </p>
     *
     * @param addListenerCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AddListenerCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>TooManyCertificatesException You've reached the limit on the number of certificates per load
     *         balancer.</li>
     *         <li>CertificateNotFoundException The specified certificate does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.AddListenerCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddListenerCertificatesResponse> addListenerCertificates(
            Consumer<AddListenerCertificatesRequest.Builder> addListenerCertificatesRequest) {
        return addListenerCertificates(AddListenerCertificatesRequest.builder().applyMutation(addListenerCertificatesRequest)
                .build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load
     * Balancers, Network Load Balancers, Gateway Load Balancers, target groups, trust stores, listeners, and rules.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key,
     * <code>AddTags</code> updates its value.
     * </p>
     *
     * @param addTagsRequest
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load
     * Balancers, Network Load Balancers, Gateway Load Balancers, target groups, trust stores, listeners, and rules.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key,
     * <code>AddTags</code> updates its value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddTagsResponse> addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Adds the specified revocation file to the specified trust store.
     * </p>
     *
     * @param addTrustStoreRevocationsRequest
     * @return A Java Future containing the result of the AddTrustStoreRevocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>InvalidRevocationContentException The provided revocation file is an invalid format, or uses an
     *         incorrect algorithm.</li>
     *         <li>TooManyTrustStoreRevocationEntriesException The specified trust store has too many revocation
     *         entries.</li>
     *         <li>RevocationContentNotFoundException The specified revocation file does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.AddTrustStoreRevocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddTrustStoreRevocationsResponse> addTrustStoreRevocations(
            AddTrustStoreRevocationsRequest addTrustStoreRevocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified revocation file to the specified trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTrustStoreRevocationsRequest.Builder} avoiding
     * the need to create one manually via {@link AddTrustStoreRevocationsRequest#builder()}
     * </p>
     *
     * @param addTrustStoreRevocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTrustStoreRevocationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AddTrustStoreRevocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>InvalidRevocationContentException The provided revocation file is an invalid format, or uses an
     *         incorrect algorithm.</li>
     *         <li>TooManyTrustStoreRevocationEntriesException The specified trust store has too many revocation
     *         entries.</li>
     *         <li>RevocationContentNotFoundException The specified revocation file does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.AddTrustStoreRevocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddTrustStoreRevocationsResponse> addTrustStoreRevocations(
            Consumer<AddTrustStoreRevocationsRequest.Builder> addTrustStoreRevocationsRequest) {
        return addTrustStoreRevocations(AddTrustStoreRevocationsRequest.builder().applyMutation(addTrustStoreRevocationsRequest)
                .build());
    }

    /**
     * <p>
     * Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">
     * Listeners for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html">Listeners
     * for your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html">Listeners for
     * your Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * listeners with the same settings, each call succeeds.
     * </p>
     *
     * @param createListenerRequest
     * @return A Java Future containing the result of the CreateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateListenerException A listener with the specified port already exists.</li>
     *         <li>TooManyListenersException You've reached the limit on the number of listeners per load balancer.</li>
     *         <li>TooManyCertificatesException You've reached the limit on the number of certificates per load
     *         balancer.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>CertificateNotFoundException The specified certificate does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>AlpnPolicyNotSupportedException The specified ALPN policy is not supported.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>TrustStoreNotReadyException The specified trust store is not active.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateListener"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/elastic-load-balancing-v2_example_elastic-load-balancing-v2_CreateListener_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CreateListenerResponse> createListener(CreateListenerRequest createListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">
     * Listeners for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html">Listeners
     * for your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html">Listeners for
     * your Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * listeners with the same settings, each call succeeds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateListenerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateListenerRequest#builder()}
     * </p>
     *
     * @param createListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateListenerException A listener with the specified port already exists.</li>
     *         <li>TooManyListenersException You've reached the limit on the number of listeners per load balancer.</li>
     *         <li>TooManyCertificatesException You've reached the limit on the number of certificates per load
     *         balancer.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>CertificateNotFoundException The specified certificate does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>AlpnPolicyNotSupportedException The specified ALPN policy is not supported.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>TrustStoreNotReadyException The specified trust store is not active.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateListener"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/elastic-load-balancing-v2_example_elastic-load-balancing-v2_CreateListener_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CreateListenerResponse> createListener(Consumer<CreateListenerRequest.Builder> createListenerRequest) {
        return createListener(CreateListenerRequest.builder().applyMutation(createListenerRequest).build());
    }

    /**
     * <p>
     * Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html">
     * Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html">Network
     * Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html">Gateway
     * Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * load balancers with the same settings, each call succeeds.
     * </p>
     *
     * @param createLoadBalancerRequest
     * @return A Java Future containing the result of the CreateLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateLoadBalancerNameException A load balancer with the specified name already exists.</li>
     *         <li>TooManyLoadBalancersException You've reached the limit on the number of load balancers for your
     *         Amazon Web Services account.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SubnetNotFoundException The specified subnet does not exist.</li>
     *         <li>InvalidSubnetException The specified subnet is out of available addresses.</li>
     *         <li>InvalidSecurityGroupException The specified security group does not exist.</li>
     *         <li>InvalidSchemeException The requested scheme is not valid.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>AllocationIdNotFoundException The specified allocation ID does not exist.</li>
     *         <li>AvailabilityZoneNotSupportedException The specified Availability Zone is not supported.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateLoadBalancer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/elastic-load-balancing-v2_example_elastic-load-balancing-v2_CreateLoadBalancer_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html">
     * Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html">Network
     * Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html">Gateway
     * Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * load balancers with the same settings, each call succeeds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoadBalancerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLoadBalancerRequest#builder()}
     * </p>
     *
     * @param createLoadBalancerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateLoadBalancerNameException A load balancer with the specified name already exists.</li>
     *         <li>TooManyLoadBalancersException You've reached the limit on the number of load balancers for your
     *         Amazon Web Services account.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SubnetNotFoundException The specified subnet does not exist.</li>
     *         <li>InvalidSubnetException The specified subnet is out of available addresses.</li>
     *         <li>InvalidSecurityGroupException The specified security group does not exist.</li>
     *         <li>InvalidSchemeException The requested scheme is not valid.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>AllocationIdNotFoundException The specified allocation ID does not exist.</li>
     *         <li>AvailabilityZoneNotSupportedException The specified Availability Zone is not supported.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateLoadBalancer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/elastic-load-balancing-v2_example_elastic-load-balancing-v2_CreateLoadBalancer_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(
            Consumer<CreateLoadBalancerRequest.Builder> createLoadBalancerRequest) {
        return createLoadBalancer(CreateLoadBalancerRequest.builder().applyMutation(createLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
     * </p>
     * <p>
     * Each rule consists of a priority, one or more actions, one or more conditions, and up to two optional transforms.
     * Rules are evaluated in priority order, from the lowest value to the highest value. When the conditions for a rule
     * are met, its actions are performed. If the conditions for no rules are met, the actions for the default rule are
     * performed. For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules"
     * >Listener rules</a> in the <i>Application Load Balancers Guide</i>.
     * </p>
     *
     * @param createRuleRequest
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>PriorityInUseException The specified priority is in use.</li>
     *         <li>TooManyTargetGroupsException You've reached the limit on the number of target groups for your Amazon
     *         Web Services account.</li>
     *         <li>TooManyRulesException You've reached the limit on the number of rules per load balancer.</li>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRuleResponse> createRule(CreateRuleRequest createRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
     * </p>
     * <p>
     * Each rule consists of a priority, one or more actions, one or more conditions, and up to two optional transforms.
     * Rules are evaluated in priority order, from the lowest value to the highest value. When the conditions for a rule
     * are met, its actions are performed. If the conditions for no rules are met, the actions for the default rule are
     * performed. For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules"
     * >Listener rules</a> in the <i>Application Load Balancers Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleRequest#builder()}
     * </p>
     *
     * @param createRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>PriorityInUseException The specified priority is in use.</li>
     *         <li>TooManyTargetGroupsException You've reached the limit on the number of target groups for your Amazon
     *         Web Services account.</li>
     *         <li>TooManyRulesException You've reached the limit on the number of rules per load balancer.</li>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRuleResponse> createRule(Consumer<CreateRuleRequest.Builder> createRuleRequest) {
        return createRule(CreateRuleRequest.builder().applyMutation(createRuleRequest).build());
    }

    /**
     * <p>
     * Creates a target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html">
     * Target groups for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html">Target
     * groups for your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html">Target groups for
     * your Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * target groups with the same settings, each call succeeds.
     * </p>
     *
     * @param createTargetGroupRequest
     * @return A Java Future containing the result of the CreateTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTargetGroupNameException A target group with the specified name already exists.</li>
     *         <li>TooManyTargetGroupsException You've reached the limit on the number of target groups for your Amazon
     *         Web Services account.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateTargetGroup"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/elastic-load-balancing-v2_example_elastic-load-balancing-v2_CreateTargetGroup_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CreateTargetGroupResponse> createTargetGroup(CreateTargetGroupRequest createTargetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html">
     * Target groups for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html">Target
     * groups for your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html">Target groups for
     * your Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * target groups with the same settings, each call succeeds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTargetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTargetGroupRequest#builder()}
     * </p>
     *
     * @param createTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTargetGroupNameException A target group with the specified name already exists.</li>
     *         <li>TooManyTargetGroupsException You've reached the limit on the number of target groups for your Amazon
     *         Web Services account.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateTargetGroup"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/elastic-load-balancing-v2_example_elastic-load-balancing-v2_CreateTargetGroup_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CreateTargetGroupResponse> createTargetGroup(
            Consumer<CreateTargetGroupRequest.Builder> createTargetGroupRequest) {
        return createTargetGroup(CreateTargetGroupRequest.builder().applyMutation(createTargetGroupRequest).build());
    }

    /**
     * <p>
     * Creates a trust store.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/mutual-authentication.html">Mutual TLS
     * for Application Load Balancers</a>.
     * </p>
     *
     * @param createTrustStoreRequest
     * @return A Java Future containing the result of the CreateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTrustStoreNameException A trust store with the specified name already exists.</li>
     *         <li>TooManyTrustStoresException You've reached the limit on the number of trust stores for your Amazon
     *         Web Services account.</li>
     *         <li>InvalidCaCertificatesBundleException The specified ca certificate bundle is in an invalid format, or
     *         corrupt.</li>
     *         <li>CaCertificatesBundleNotFoundException The specified ca certificate bundle does not exist.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrustStoreResponse> createTrustStore(CreateTrustStoreRequest createTrustStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a trust store.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/mutual-authentication.html">Mutual TLS
     * for Application Load Balancers</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrustStoreRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTrustStoreRequest#builder()}
     * </p>
     *
     * @param createTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTrustStoreRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTrustStoreNameException A trust store with the specified name already exists.</li>
     *         <li>TooManyTrustStoresException You've reached the limit on the number of trust stores for your Amazon
     *         Web Services account.</li>
     *         <li>InvalidCaCertificatesBundleException The specified ca certificate bundle is in an invalid format, or
     *         corrupt.</li>
     *         <li>CaCertificatesBundleNotFoundException The specified ca certificate bundle does not exist.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrustStoreResponse> createTrustStore(
            Consumer<CreateTrustStoreRequest.Builder> createTrustStoreRequest) {
        return createTrustStore(CreateTrustStoreRequest.builder().applyMutation(createTrustStoreRequest).build());
    }

    /**
     * <p>
     * Deletes the specified listener.
     * </p>
     * <p>
     * Alternatively, your listener is deleted when you delete the load balancer to which it is attached.
     * </p>
     *
     * @param deleteListenerRequest
     * @return A Java Future containing the result of the DeleteListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteListenerResponse> deleteListener(DeleteListenerRequest deleteListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified listener.
     * </p>
     * <p>
     * Alternatively, your listener is deleted when you delete the load balancer to which it is attached.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteListenerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteListenerRequest#builder()}
     * </p>
     *
     * @param deleteListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteListenerResponse> deleteListener(Consumer<DeleteListenerRequest.Builder> deleteListenerRequest) {
        return deleteListener(DeleteListenerRequest.builder().applyMutation(deleteListenerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load
     * balancer also deletes its listeners.
     * </p>
     * <p>
     * You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has
     * already been deleted, the call succeeds.
     * </p>
     * <p>
     * Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run
     * and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or
     * terminate them.
     * </p>
     *
     * @param deleteLoadBalancerRequest
     * @return A Java Future containing the result of the DeleteLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteLoadBalancer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/elastic-load-balancing-v2_example_elastic-load-balancing-v2_DeleteLoadBalancer_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load
     * balancer also deletes its listeners.
     * </p>
     * <p>
     * You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has
     * already been deleted, the call succeeds.
     * </p>
     * <p>
     * Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run
     * and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or
     * terminate them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoadBalancerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLoadBalancerRequest#builder()}
     * </p>
     *
     * @param deleteLoadBalancerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteLoadBalancer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/elastic-load-balancing-v2_example_elastic-load-balancing-v2_DeleteLoadBalancer_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(
            Consumer<DeleteLoadBalancerRequest.Builder> deleteLoadBalancerRequest) {
        return deleteLoadBalancer(DeleteLoadBalancerRequest.builder().applyMutation(deleteLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified rule.
     * </p>
     * <p>
     * You can't delete the default rule.
     * </p>
     *
     * @param deleteRuleRequest
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRuleResponse> deleteRule(DeleteRuleRequest deleteRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified rule.
     * </p>
     * <p>
     * You can't delete the default rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleRequest#builder()}
     * </p>
     *
     * @param deleteRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRuleResponse> deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest) {
        return deleteRule(DeleteRuleRequest.builder().applyMutation(deleteRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a shared trust store association.
     * </p>
     *
     * @param deleteSharedTrustStoreAssociationRequest
     * @return A Java Future containing the result of the DeleteSharedTrustStoreAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>DeleteAssociationSameAccountException The specified association can't be within the same account.</li>
     *         <li>TrustStoreAssociationNotFoundException The specified association does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteSharedTrustStoreAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteSharedTrustStoreAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSharedTrustStoreAssociationResponse> deleteSharedTrustStoreAssociation(
            DeleteSharedTrustStoreAssociationRequest deleteSharedTrustStoreAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a shared trust store association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSharedTrustStoreAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSharedTrustStoreAssociationRequest#builder()}
     * </p>
     *
     * @param deleteSharedTrustStoreAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteSharedTrustStoreAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteSharedTrustStoreAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>DeleteAssociationSameAccountException The specified association can't be within the same account.</li>
     *         <li>TrustStoreAssociationNotFoundException The specified association does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteSharedTrustStoreAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteSharedTrustStoreAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSharedTrustStoreAssociationResponse> deleteSharedTrustStoreAssociation(
            Consumer<DeleteSharedTrustStoreAssociationRequest.Builder> deleteSharedTrustStoreAssociationRequest) {
        return deleteSharedTrustStoreAssociation(DeleteSharedTrustStoreAssociationRequest.builder()
                .applyMutation(deleteSharedTrustStoreAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified target group.
     * </p>
     * <p>
     * You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any
     * associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2
     * instances continue to run until you stop or terminate them.
     * </p>
     *
     * @param deleteTargetGroupRequest
     * @return A Java Future containing the result of the DeleteTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteTargetGroup"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/elastic-load-balancing-v2_example_elastic-load-balancing-v2_DeleteTargetGroup_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DeleteTargetGroupResponse> deleteTargetGroup(DeleteTargetGroupRequest deleteTargetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified target group.
     * </p>
     * <p>
     * You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any
     * associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2
     * instances continue to run until you stop or terminate them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTargetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTargetGroupRequest#builder()}
     * </p>
     *
     * @param deleteTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteTargetGroup"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/elastic-load-balancing-v2_example_elastic-load-balancing-v2_DeleteTargetGroup_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DeleteTargetGroupResponse> deleteTargetGroup(
            Consumer<DeleteTargetGroupRequest.Builder> deleteTargetGroupRequest) {
        return deleteTargetGroup(DeleteTargetGroupRequest.builder().applyMutation(deleteTargetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a trust store.
     * </p>
     *
     * @param deleteTrustStoreRequest
     * @return A Java Future containing the result of the DeleteTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>TrustStoreInUseException The specified trust store is currently in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrustStoreResponse> deleteTrustStore(DeleteTrustStoreRequest deleteTrustStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrustStoreRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTrustStoreRequest#builder()}
     * </p>
     *
     * @param deleteTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTrustStoreRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>TrustStoreInUseException The specified trust store is currently in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrustStoreResponse> deleteTrustStore(
            Consumer<DeleteTrustStoreRequest.Builder> deleteTrustStoreRequest) {
        return deleteTrustStore(DeleteTrustStoreRequest.builder().applyMutation(deleteTrustStoreRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified targets from the specified target group. After the targets are deregistered, they no
     * longer receive traffic from the load balancer.
     * </p>
     * <p>
     * The load balancer stops sending requests to targets that are deregistering, but uses connection draining to
     * ensure that in-flight traffic completes on the existing connections. This deregistration delay is configured by
     * default but can be updated for each target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/edit-target-group-attributes.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Application Load Balancers User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/edit-target-group-attributes.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Network Load Balancers User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/edit-target-group-attributes.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Gateway Load Balancers User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note: If the specified target does not exist, the action returns successfully.
     * </p>
     *
     * @param deregisterTargetsRequest
     * @return A Java Future containing the result of the DeregisterTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidTargetException The specified target does not exist, is not in the same VPC as the target
     *         group, or has an unsupported instance type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeregisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeregisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTargetsResponse> deregisterTargets(DeregisterTargetsRequest deregisterTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified targets from the specified target group. After the targets are deregistered, they no
     * longer receive traffic from the load balancer.
     * </p>
     * <p>
     * The load balancer stops sending requests to targets that are deregistering, but uses connection draining to
     * ensure that in-flight traffic completes on the existing connections. This deregistration delay is configured by
     * default but can be updated for each target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/edit-target-group-attributes.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Application Load Balancers User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/edit-target-group-attributes.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Network Load Balancers User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/edit-target-group-attributes.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Gateway Load Balancers User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note: If the specified target does not exist, the action returns successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterTargetsRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterTargetsRequest#builder()}
     * </p>
     *
     * @param deregisterTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeregisterTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidTargetException The specified target does not exist, is not in the same VPC as the target
     *         group, or has an unsupported instance type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeregisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeregisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTargetsResponse> deregisterTargets(
            Consumer<DeregisterTargetsRequest.Builder> deregisterTargetsRequest) {
        return deregisterTargets(DeregisterTargetsRequest.builder().applyMutation(deregisterTargetsRequest).build());
    }

    /**
     * <p>
     * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas
     * for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Quotas for
     * your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html">Quotas for your
     * Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountLimitsRequest
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas
     * for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Quotas for
     * your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html">Quotas for your
     * Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest).build());
    }

    /**
     * <p>
     * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas
     * for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Quotas for
     * your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html">Quotas for your
     * Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits() {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsPublisher describeAccountLimitsPaginator() {
        return describeAccountLimitsPaginator(DescribeAccountLimitsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAccountLimitsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsPublisher describeAccountLimitsPaginator(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        return new DescribeAccountLimitsPublisher(this, describeAccountLimitsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsPublisher describeAccountLimitsPaginator(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) {
        return describeAccountLimitsPaginator(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the capacity reservation status for the specified load balancer.
     * </p>
     *
     * @param describeCapacityReservationRequest
     * @return A Java Future containing the result of the DescribeCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeCapacityReservation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCapacityReservationResponse> describeCapacityReservation(
            DescribeCapacityReservationRequest describeCapacityReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the capacity reservation status for the specified load balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCapacityReservationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCapacityReservationRequest#builder()}
     * </p>
     *
     * @param describeCapacityReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeCapacityReservationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeCapacityReservation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCapacityReservationResponse> describeCapacityReservation(
            Consumer<DescribeCapacityReservationRequest.Builder> describeCapacityReservationRequest) {
        return describeCapacityReservation(DescribeCapacityReservationRequest.builder()
                .applyMutation(describeCapacityReservationRequest).build());
    }

    /**
     * <p>
     * Describes the attributes for the specified listener.
     * </p>
     *
     * @param describeListenerAttributesRequest
     * @return A Java Future containing the result of the DescribeListenerAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListenerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeListenerAttributesResponse> describeListenerAttributes(
            DescribeListenerAttributesRequest describeListenerAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the attributes for the specified listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeListenerAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeListenerAttributesRequest#builder()}
     * </p>
     *
     * @param describeListenerAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerAttributesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeListenerAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListenerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeListenerAttributesResponse> describeListenerAttributes(
            Consumer<DescribeListenerAttributesRequest.Builder> describeListenerAttributesRequest) {
        return describeListenerAttributes(DescribeListenerAttributesRequest.builder()
                .applyMutation(describeListenerAttributesRequest).build());
    }

    /**
     * <p>
     * Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the default certificate is also in the certificate list, it appears twice in the results (once with
     * <code>IsDefault</code> set to true and once with <code>IsDefault</code> set to false).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/https-listener-certificates.html">SSL
     * certificates</a> in the <i>Application Load Balancers Guide</i> or <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/tls-listener-certificates.html">Server
     * certificates</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param describeListenerCertificatesRequest
     * @return A Java Future containing the result of the DescribeListenerCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeListenerCertificatesResponse> describeListenerCertificates(
            DescribeListenerCertificatesRequest describeListenerCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the default certificate is also in the certificate list, it appears twice in the results (once with
     * <code>IsDefault</code> set to true and once with <code>IsDefault</code> set to false).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/https-listener-certificates.html">SSL
     * certificates</a> in the <i>Application Load Balancers Guide</i> or <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/tls-listener-certificates.html">Server
     * certificates</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeListenerCertificatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeListenerCertificatesRequest#builder()}
     * </p>
     *
     * @param describeListenerCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeListenerCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeListenerCertificatesResponse> describeListenerCertificates(
            Consumer<DescribeListenerCertificatesRequest.Builder> describeListenerCertificatesRequest) {
        return describeListenerCertificates(DescribeListenerCertificatesRequest.builder()
                .applyMutation(describeListenerCertificatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeListenerCertificates(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenerCertificatesPublisher publisher = client.describeListenerCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenerCertificatesPublisher publisher = client.describeListenerCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeListenerCertificates(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeListenerCertificatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeListenerCertificatesPublisher describeListenerCertificatesPaginator(
            DescribeListenerCertificatesRequest describeListenerCertificatesRequest) {
        return new DescribeListenerCertificatesPublisher(this, describeListenerCertificatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeListenerCertificates(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenerCertificatesPublisher publisher = client.describeListenerCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenerCertificatesPublisher publisher = client.describeListenerCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeListenerCertificates(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeListenerCertificatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeListenerCertificatesRequest#builder()}
     * </p>
     *
     * @param describeListenerCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeListenerCertificatesPublisher describeListenerCertificatesPaginator(
            Consumer<DescribeListenerCertificatesRequest.Builder> describeListenerCertificatesRequest) {
        return describeListenerCertificatesPaginator(DescribeListenerCertificatesRequest.builder()
                .applyMutation(describeListenerCertificatesRequest).build());
    }

    /**
     * <p>
     * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load
     * Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
     * </p>
     *
     * @param describeListenersRequest
     * @return A Java Future containing the result of the DescribeListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeListenersResponse> describeListeners(DescribeListenersRequest describeListenersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load
     * Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeListenersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeListenersRequest#builder()}
     * </p>
     *
     * @param describeListenersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeListenersResponse> describeListeners(
            Consumer<DescribeListenersRequest.Builder> describeListenersRequest) {
        return describeListeners(DescribeListenersRequest.builder().applyMutation(describeListenersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeListeners(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersPublisher publisher = client.describeListenersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersPublisher publisher = client.describeListenersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeListeners(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeListenersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeListenersPublisher describeListenersPaginator(DescribeListenersRequest describeListenersRequest) {
        return new DescribeListenersPublisher(this, describeListenersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeListeners(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersPublisher publisher = client.describeListenersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersPublisher publisher = client.describeListenersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeListeners(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeListenersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeListenersRequest#builder()}
     * </p>
     *
     * @param describeListenersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeListenersPublisher describeListenersPaginator(
            Consumer<DescribeListenersRequest.Builder> describeListenersRequest) {
        return describeListenersPaginator(DescribeListenersRequest.builder().applyMutation(describeListenersRequest).build());
    }

    /**
     * <p>
     * Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load
     * Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Application Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Network Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Gateway Load Balancers Guide</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeLoadBalancerAttributesRequest
     * @return A Java Future containing the result of the DescribeLoadBalancerAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoadBalancerAttributesResponse> describeLoadBalancerAttributes(
            DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load
     * Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Application Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Network Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Gateway Load Balancers Guide</i>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancerAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLoadBalancerAttributesRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancerAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeLoadBalancerAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoadBalancerAttributesResponse> describeLoadBalancerAttributes(
            Consumer<DescribeLoadBalancerAttributesRequest.Builder> describeLoadBalancerAttributesRequest) {
        return describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest.builder()
                .applyMutation(describeLoadBalancerAttributesRequest).build());
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return A Java Future containing the result of the DescribeLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoadBalancersResponse> describeLoadBalancers(
            DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoadBalancersRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoadBalancersResponse> describeLoadBalancers(
            Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest) {
        return describeLoadBalancers(DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest).build());
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoadBalancersResponse> describeLoadBalancers() {
        return describeLoadBalancers(DescribeLoadBalancersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersPublisher publisher = client.describeLoadBalancersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersPublisher publisher = client.describeLoadBalancersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersPublisher describeLoadBalancersPaginator() {
        return describeLoadBalancersPaginator(DescribeLoadBalancersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersPublisher publisher = client.describeLoadBalancersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersPublisher publisher = client.describeLoadBalancersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersPublisher describeLoadBalancersPaginator(
            DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        return new DescribeLoadBalancersPublisher(this, describeLoadBalancersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersPublisher publisher = client.describeLoadBalancersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersPublisher publisher = client.describeLoadBalancersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoadBalancersRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersPublisher describeLoadBalancersPaginator(
            Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest) {
        return describeLoadBalancersPaginator(DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified rules or the rules for the specified listener. You must specify either a listener or
     * rules.
     * </p>
     *
     * @param describeRulesRequest
     * @return A Java Future containing the result of the DescribeRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRulesResponse> describeRules(DescribeRulesRequest describeRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified rules or the rules for the specified listener. You must specify either a listener or
     * rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRulesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRulesRequest#builder()}
     * </p>
     *
     * @param describeRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRulesResponse> describeRules(Consumer<DescribeRulesRequest.Builder> describeRulesRequest) {
        return describeRules(DescribeRulesRequest.builder().applyMutation(describeRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRules(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeRulesPublisher publisher = client.describeRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeRulesPublisher publisher = client.describeRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRules(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRulesPublisher describeRulesPaginator(DescribeRulesRequest describeRulesRequest) {
        return new DescribeRulesPublisher(this, describeRulesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRules(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeRulesPublisher publisher = client.describeRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeRulesPublisher publisher = client.describeRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRules(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRulesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRulesRequest#builder()}
     * </p>
     *
     * @param describeRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRulesPublisher describeRulesPaginator(Consumer<DescribeRulesRequest.Builder> describeRulesRequest) {
        return describeRulesPaginator(DescribeRulesRequest.builder().applyMutation(describeRulesRequest).build());
    }

    /**
     * <p>
     * Describes the specified policies or all policies used for SSL negotiation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/describe-ssl-policies.html">Security
     * policies</a> in the <i>Application Load Balancers Guide</i> and <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/describe-ssl-policies.html">Security
     * policies</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param describeSslPoliciesRequest
     * @return A Java Future containing the result of the DescribeSSLPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeSSLPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeSSLPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSslPoliciesResponse> describeSSLPolicies(
            DescribeSslPoliciesRequest describeSslPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified policies or all policies used for SSL negotiation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/describe-ssl-policies.html">Security
     * policies</a> in the <i>Application Load Balancers Guide</i> and <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/describe-ssl-policies.html">Security
     * policies</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSslPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSslPoliciesRequest#builder()}
     * </p>
     *
     * @param describeSslPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeSSLPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeSSLPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeSSLPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSslPoliciesResponse> describeSSLPolicies(
            Consumer<DescribeSslPoliciesRequest.Builder> describeSslPoliciesRequest) {
        return describeSSLPolicies(DescribeSslPoliciesRequest.builder().applyMutation(describeSslPoliciesRequest).build());
    }

    /**
     * <p>
     * Describes the specified policies or all policies used for SSL negotiation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/describe-ssl-policies.html">Security
     * policies</a> in the <i>Application Load Balancers Guide</i> and <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/describe-ssl-policies.html">Security
     * policies</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeSSLPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeSSLPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeSSLPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSslPoliciesResponse> describeSSLPolicies() {
        return describeSSLPolicies(DescribeSslPoliciesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more
     * Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
     * </p>
     *
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more
     * Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTagsResponse> describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest) {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Describes the attributes for the specified target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Application Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Network Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Gateway Load Balancers Guide</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeTargetGroupAttributesRequest
     * @return A Java Future containing the result of the DescribeTargetGroupAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroupAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTargetGroupAttributesResponse> describeTargetGroupAttributes(
            DescribeTargetGroupAttributesRequest describeTargetGroupAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the attributes for the specified target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Application Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Network Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Gateway Load Balancers Guide</i>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTargetGroupAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTargetGroupAttributesRequest#builder()}
     * </p>
     *
     * @param describeTargetGroupAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeTargetGroupAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroupAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTargetGroupAttributesResponse> describeTargetGroupAttributes(
            Consumer<DescribeTargetGroupAttributesRequest.Builder> describeTargetGroupAttributesRequest) {
        return describeTargetGroupAttributes(DescribeTargetGroupAttributesRequest.builder()
                .applyMutation(describeTargetGroupAttributesRequest).build());
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     *
     * @param describeTargetGroupsRequest
     * @return A Java Future containing the result of the DescribeTargetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTargetGroupsResponse> describeTargetGroups(
            DescribeTargetGroupsRequest describeTargetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTargetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTargetGroupsRequest#builder()}
     * </p>
     *
     * @param describeTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeTargetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTargetGroupsResponse> describeTargetGroups(
            Consumer<DescribeTargetGroupsRequest.Builder> describeTargetGroupsRequest) {
        return describeTargetGroups(DescribeTargetGroupsRequest.builder().applyMutation(describeTargetGroupsRequest).build());
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeTargetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTargetGroupsResponse> describeTargetGroups() {
        return describeTargetGroups(DescribeTargetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsPublisher publisher = client.describeTargetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsPublisher publisher = client.describeTargetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetGroupsPublisher describeTargetGroupsPaginator() {
        return describeTargetGroupsPaginator(DescribeTargetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsPublisher publisher = client.describeTargetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsPublisher publisher = client.describeTargetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTargetGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetGroupsPublisher describeTargetGroupsPaginator(DescribeTargetGroupsRequest describeTargetGroupsRequest) {
        return new DescribeTargetGroupsPublisher(this, describeTargetGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsPublisher publisher = client.describeTargetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsPublisher publisher = client.describeTargetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTargetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTargetGroupsRequest#builder()}
     * </p>
     *
     * @param describeTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetGroupsPublisher describeTargetGroupsPaginator(
            Consumer<DescribeTargetGroupsRequest.Builder> describeTargetGroupsRequest) {
        return describeTargetGroupsPaginator(DescribeTargetGroupsRequest.builder().applyMutation(describeTargetGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the health of the specified targets or all of your targets.
     * </p>
     *
     * @param describeTargetHealthRequest
     * @return A Java Future containing the result of the DescribeTargetHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidTargetException The specified target does not exist, is not in the same VPC as the target
     *         group, or has an unsupported instance type.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>HealthUnavailableException The health of the specified targets could not be retrieved due to an
     *         internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetHealth"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/elastic-load-balancing-v2_example_elastic-load-balancing-v2_DescribeTargetHealth_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DescribeTargetHealthResponse> describeTargetHealth(
            DescribeTargetHealthRequest describeTargetHealthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the health of the specified targets or all of your targets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTargetHealthRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTargetHealthRequest#builder()}
     * </p>
     *
     * @param describeTargetHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeTargetHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidTargetException The specified target does not exist, is not in the same VPC as the target
     *         group, or has an unsupported instance type.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>HealthUnavailableException The health of the specified targets could not be retrieved due to an
     *         internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetHealth"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/elastic-load-balancing-v2_example_elastic-load-balancing-v2_DescribeTargetHealth_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DescribeTargetHealthResponse> describeTargetHealth(
            Consumer<DescribeTargetHealthRequest.Builder> describeTargetHealthRequest) {
        return describeTargetHealth(DescribeTargetHealthRequest.builder().applyMutation(describeTargetHealthRequest).build());
    }

    /**
     * <p>
     * Describes all resources associated with the specified trust store.
     * </p>
     *
     * @param describeTrustStoreAssociationsRequest
     * @return A Java Future containing the result of the DescribeTrustStoreAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStoreAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStoreAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustStoreAssociationsResponse> describeTrustStoreAssociations(
            DescribeTrustStoreAssociationsRequest describeTrustStoreAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all resources associated with the specified trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrustStoreAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTrustStoreAssociationsRequest#builder()}
     * </p>
     *
     * @param describeTrustStoreAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeTrustStoreAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStoreAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStoreAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustStoreAssociationsResponse> describeTrustStoreAssociations(
            Consumer<DescribeTrustStoreAssociationsRequest.Builder> describeTrustStoreAssociationsRequest) {
        return describeTrustStoreAssociations(DescribeTrustStoreAssociationsRequest.builder()
                .applyMutation(describeTrustStoreAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTrustStoreAssociations(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoreAssociationsPublisher publisher = client.describeTrustStoreAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoreAssociationsPublisher publisher = client.describeTrustStoreAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrustStoreAssociations(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTrustStoreAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStoreAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStoreAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrustStoreAssociationsPublisher describeTrustStoreAssociationsPaginator(
            DescribeTrustStoreAssociationsRequest describeTrustStoreAssociationsRequest) {
        return new DescribeTrustStoreAssociationsPublisher(this, describeTrustStoreAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTrustStoreAssociations(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoreAssociationsPublisher publisher = client.describeTrustStoreAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoreAssociationsPublisher publisher = client.describeTrustStoreAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrustStoreAssociations(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrustStoreAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTrustStoreAssociationsRequest#builder()}
     * </p>
     *
     * @param describeTrustStoreAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStoreAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStoreAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrustStoreAssociationsPublisher describeTrustStoreAssociationsPaginator(
            Consumer<DescribeTrustStoreAssociationsRequest.Builder> describeTrustStoreAssociationsRequest) {
        return describeTrustStoreAssociationsPaginator(DescribeTrustStoreAssociationsRequest.builder()
                .applyMutation(describeTrustStoreAssociationsRequest).build());
    }

    /**
     * <p>
     * Describes the revocation files in use by the specified trust store or revocation files.
     * </p>
     *
     * @param describeTrustStoreRevocationsRequest
     * @return A Java Future containing the result of the DescribeTrustStoreRevocations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>RevocationIdNotFoundException The specified revocation ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStoreRevocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustStoreRevocationsResponse> describeTrustStoreRevocations(
            DescribeTrustStoreRevocationsRequest describeTrustStoreRevocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the revocation files in use by the specified trust store or revocation files.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrustStoreRevocationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTrustStoreRevocationsRequest#builder()}
     * </p>
     *
     * @param describeTrustStoreRevocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeTrustStoreRevocations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>RevocationIdNotFoundException The specified revocation ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStoreRevocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustStoreRevocationsResponse> describeTrustStoreRevocations(
            Consumer<DescribeTrustStoreRevocationsRequest.Builder> describeTrustStoreRevocationsRequest) {
        return describeTrustStoreRevocations(DescribeTrustStoreRevocationsRequest.builder()
                .applyMutation(describeTrustStoreRevocationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTrustStoreRevocations(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoreRevocationsPublisher publisher = client.describeTrustStoreRevocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoreRevocationsPublisher publisher = client.describeTrustStoreRevocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrustStoreRevocations(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTrustStoreRevocationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>RevocationIdNotFoundException The specified revocation ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStoreRevocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrustStoreRevocationsPublisher describeTrustStoreRevocationsPaginator(
            DescribeTrustStoreRevocationsRequest describeTrustStoreRevocationsRequest) {
        return new DescribeTrustStoreRevocationsPublisher(this, describeTrustStoreRevocationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTrustStoreRevocations(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoreRevocationsPublisher publisher = client.describeTrustStoreRevocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoreRevocationsPublisher publisher = client.describeTrustStoreRevocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrustStoreRevocations(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrustStoreRevocationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTrustStoreRevocationsRequest#builder()}
     * </p>
     *
     * @param describeTrustStoreRevocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>RevocationIdNotFoundException The specified revocation ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStoreRevocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrustStoreRevocationsPublisher describeTrustStoreRevocationsPaginator(
            Consumer<DescribeTrustStoreRevocationsRequest.Builder> describeTrustStoreRevocationsRequest) {
        return describeTrustStoreRevocationsPaginator(DescribeTrustStoreRevocationsRequest.builder()
                .applyMutation(describeTrustStoreRevocationsRequest).build());
    }

    /**
     * <p>
     * Describes all trust stores for the specified account.
     * </p>
     *
     * @param describeTrustStoresRequest
     * @return A Java Future containing the result of the DescribeTrustStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustStoresResponse> describeTrustStores(
            DescribeTrustStoresRequest describeTrustStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all trust stores for the specified account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrustStoresRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrustStoresRequest#builder()}
     * </p>
     *
     * @param describeTrustStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeTrustStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrustStoresResponse> describeTrustStores(
            Consumer<DescribeTrustStoresRequest.Builder> describeTrustStoresRequest) {
        return describeTrustStores(DescribeTrustStoresRequest.builder().applyMutation(describeTrustStoresRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTrustStores(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoresPublisher publisher = client.describeTrustStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoresPublisher publisher = client.describeTrustStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrustStores(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTrustStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrustStoresPublisher describeTrustStoresPaginator(DescribeTrustStoresRequest describeTrustStoresRequest) {
        return new DescribeTrustStoresPublisher(this, describeTrustStoresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTrustStores(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoresPublisher publisher = client.describeTrustStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTrustStoresPublisher publisher = client.describeTrustStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrustStores(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrustStoresRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrustStoresRequest#builder()}
     * </p>
     *
     * @param describeTrustStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrustStoresPublisher describeTrustStoresPaginator(
            Consumer<DescribeTrustStoresRequest.Builder> describeTrustStoresRequest) {
        return describeTrustStoresPaginator(DescribeTrustStoresRequest.builder().applyMutation(describeTrustStoresRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the resource policy for a specified resource.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource policy for a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.GetResourcePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the ca certificate bundle.
     * </p>
     * <p>
     * This action returns a pre-signed S3 URI which is active for ten minutes.
     * </p>
     *
     * @param getTrustStoreCaCertificatesBundleRequest
     * @return A Java Future containing the result of the GetTrustStoreCaCertificatesBundle operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.GetTrustStoreCaCertificatesBundle
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/GetTrustStoreCaCertificatesBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrustStoreCaCertificatesBundleResponse> getTrustStoreCaCertificatesBundle(
            GetTrustStoreCaCertificatesBundleRequest getTrustStoreCaCertificatesBundleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the ca certificate bundle.
     * </p>
     * <p>
     * This action returns a pre-signed S3 URI which is active for ten minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrustStoreCaCertificatesBundleRequest.Builder}
     * avoiding the need to create one manually via {@link GetTrustStoreCaCertificatesBundleRequest#builder()}
     * </p>
     *
     * @param getTrustStoreCaCertificatesBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreCaCertificatesBundleRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetTrustStoreCaCertificatesBundle operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.GetTrustStoreCaCertificatesBundle
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/GetTrustStoreCaCertificatesBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrustStoreCaCertificatesBundleResponse> getTrustStoreCaCertificatesBundle(
            Consumer<GetTrustStoreCaCertificatesBundleRequest.Builder> getTrustStoreCaCertificatesBundleRequest) {
        return getTrustStoreCaCertificatesBundle(GetTrustStoreCaCertificatesBundleRequest.builder()
                .applyMutation(getTrustStoreCaCertificatesBundleRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified revocation file.
     * </p>
     * <p>
     * This action returns a pre-signed S3 URI which is active for ten minutes.
     * </p>
     *
     * @param getTrustStoreRevocationContentRequest
     * @return A Java Future containing the result of the GetTrustStoreRevocationContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>RevocationIdNotFoundException The specified revocation ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.GetTrustStoreRevocationContent
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/GetTrustStoreRevocationContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrustStoreRevocationContentResponse> getTrustStoreRevocationContent(
            GetTrustStoreRevocationContentRequest getTrustStoreRevocationContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified revocation file.
     * </p>
     * <p>
     * This action returns a pre-signed S3 URI which is active for ten minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrustStoreRevocationContentRequest.Builder}
     * avoiding the need to create one manually via {@link GetTrustStoreRevocationContentRequest#builder()}
     * </p>
     *
     * @param getTrustStoreRevocationContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreRevocationContentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetTrustStoreRevocationContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>RevocationIdNotFoundException The specified revocation ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.GetTrustStoreRevocationContent
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/GetTrustStoreRevocationContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrustStoreRevocationContentResponse> getTrustStoreRevocationContent(
            Consumer<GetTrustStoreRevocationContentRequest.Builder> getTrustStoreRevocationContentRequest) {
        return getTrustStoreRevocationContent(GetTrustStoreRevocationContentRequest.builder()
                .applyMutation(getTrustStoreRevocationContentRequest).build());
    }

    /**
     * <p>
     * Modifies the capacity reservation of the specified load balancer.
     * </p>
     * <p>
     * When modifying capacity reservation, you must include at least one <code>MinimumLoadBalancerCapacity</code> or
     * <code>ResetCapacityReservation</code>.
     * </p>
     *
     * @param modifyCapacityReservationRequest
     * @return A Java Future containing the result of the ModifyCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>CapacityUnitsLimitExceededException You've exceeded the capacity units limit.</li>
     *         <li>CapacityReservationPendingException There is a pending capacity reservation.</li>
     *         <li>InsufficientCapacityException There is insufficient capacity to reserve.</li>
     *         <li>CapacityDecreaseRequestsLimitExceededException You've exceeded the daily capacity decrease limit for
     *         this reservation.</li>
     *         <li>PriorRequestNotCompleteException This operation is not allowed while a prior request has not been
     *         completed.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyCapacityReservation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyCapacityReservationResponse> modifyCapacityReservation(
            ModifyCapacityReservationRequest modifyCapacityReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the capacity reservation of the specified load balancer.
     * </p>
     * <p>
     * When modifying capacity reservation, you must include at least one <code>MinimumLoadBalancerCapacity</code> or
     * <code>ResetCapacityReservation</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyCapacityReservationRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyCapacityReservationRequest#builder()}
     * </p>
     *
     * @param modifyCapacityReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyCapacityReservationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ModifyCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>CapacityUnitsLimitExceededException You've exceeded the capacity units limit.</li>
     *         <li>CapacityReservationPendingException There is a pending capacity reservation.</li>
     *         <li>InsufficientCapacityException There is insufficient capacity to reserve.</li>
     *         <li>CapacityDecreaseRequestsLimitExceededException You've exceeded the daily capacity decrease limit for
     *         this reservation.</li>
     *         <li>PriorRequestNotCompleteException This operation is not allowed while a prior request has not been
     *         completed.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyCapacityReservation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyCapacityReservationResponse> modifyCapacityReservation(
            Consumer<ModifyCapacityReservationRequest.Builder> modifyCapacityReservationRequest) {
        return modifyCapacityReservation(ModifyCapacityReservationRequest.builder()
                .applyMutation(modifyCapacityReservationRequest).build());
    }

    /**
     * <p>
     * [Application Load Balancers] Modify the IP pool associated to a load balancer.
     * </p>
     *
     * @param modifyIpPoolsRequest
     * @return A Java Future containing the result of the ModifyIpPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyIpPools"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyIpPoolsResponse> modifyIpPools(ModifyIpPoolsRequest modifyIpPoolsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * [Application Load Balancers] Modify the IP pool associated to a load balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyIpPoolsRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyIpPoolsRequest#builder()}
     * </p>
     *
     * @param modifyIpPoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyIpPoolsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyIpPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyIpPools"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyIpPoolsResponse> modifyIpPools(Consumer<ModifyIpPoolsRequest.Builder> modifyIpPoolsRequest) {
        return modifyIpPools(ModifyIpPoolsRequest.builder().applyMutation(modifyIpPoolsRequest).build());
    }

    /**
     * <p>
     * Replaces the specified properties of the specified listener. Any properties that you do not specify remain
     * unchanged.
     * </p>
     * <p>
     * Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate
     * properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy
     * and default certificate properties.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     *
     * @param modifyListenerRequest
     * @return A Java Future containing the result of the ModifyListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateListenerException A listener with the specified port already exists.</li>
     *         <li>TooManyListenersException You've reached the limit on the number of listeners per load balancer.</li>
     *         <li>TooManyCertificatesException You've reached the limit on the number of certificates per load
     *         balancer.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>CertificateNotFoundException The specified certificate does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>AlpnPolicyNotSupportedException The specified ALPN policy is not supported.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>TrustStoreNotReadyException The specified trust store is not active.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyListenerResponse> modifyListener(ModifyListenerRequest modifyListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the specified properties of the specified listener. Any properties that you do not specify remain
     * unchanged.
     * </p>
     * <p>
     * Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate
     * properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy
     * and default certificate properties.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyListenerRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyListenerRequest#builder()}
     * </p>
     *
     * @param modifyListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateListenerException A listener with the specified port already exists.</li>
     *         <li>TooManyListenersException You've reached the limit on the number of listeners per load balancer.</li>
     *         <li>TooManyCertificatesException You've reached the limit on the number of certificates per load
     *         balancer.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>CertificateNotFoundException The specified certificate does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>AlpnPolicyNotSupportedException The specified ALPN policy is not supported.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>TrustStoreNotReadyException The specified trust store is not active.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyListenerResponse> modifyListener(Consumer<ModifyListenerRequest.Builder> modifyListenerRequest) {
        return modifyListener(ModifyListenerRequest.builder().applyMutation(modifyListenerRequest).build());
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified listener.
     * </p>
     *
     * @param modifyListenerAttributesRequest
     * @return A Java Future containing the result of the ModifyListenerAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyListenerAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyListenerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyListenerAttributesResponse> modifyListenerAttributes(
            ModifyListenerAttributesRequest modifyListenerAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyListenerAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyListenerAttributesRequest#builder()}
     * </p>
     *
     * @param modifyListenerAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerAttributesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ModifyListenerAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyListenerAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyListenerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyListenerAttributesResponse> modifyListenerAttributes(
            Consumer<ModifyListenerAttributesRequest.Builder> modifyListenerAttributesRequest) {
        return modifyListenerAttributes(ModifyListenerAttributesRequest.builder().applyMutation(modifyListenerAttributesRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway
     * Load Balancer.
     * </p>
     * <p>
     * If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that
     * you do not modify retain their current values.
     * </p>
     *
     * @param modifyLoadBalancerAttributesRequest
     * @return A Java Future containing the result of the ModifyLoadBalancerAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyLoadBalancerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyLoadBalancerAttributesResponse> modifyLoadBalancerAttributes(
            ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway
     * Load Balancer.
     * </p>
     * <p>
     * If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that
     * you do not modify retain their current values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyLoadBalancerAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyLoadBalancerAttributesRequest#builder()}
     * </p>
     *
     * @param modifyLoadBalancerAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ModifyLoadBalancerAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyLoadBalancerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyLoadBalancerAttributesResponse> modifyLoadBalancerAttributes(
            Consumer<ModifyLoadBalancerAttributesRequest.Builder> modifyLoadBalancerAttributesRequest) {
        return modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest.builder()
                .applyMutation(modifyLoadBalancerAttributesRequest).build());
    }

    /**
     * <p>
     * Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     *
     * @param modifyRuleRequest
     * @return A Java Future containing the result of the ModifyRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyRuleResponse> modifyRule(ModifyRuleRequest modifyRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyRuleRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyRuleRequest#builder()}
     * </p>
     *
     * @param modifyRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyRuleResponse> modifyRule(Consumer<ModifyRuleRequest.Builder> modifyRuleRequest) {
        return modifyRule(ModifyRuleRequest.builder().applyMutation(modifyRuleRequest).build());
    }

    /**
     * <p>
     * Modifies the health checks used when evaluating the health state of the targets in the specified target group.
     * </p>
     *
     * @param modifyTargetGroupRequest
     * @return A Java Future containing the result of the ModifyTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyTargetGroupResponse> modifyTargetGroup(ModifyTargetGroupRequest modifyTargetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the health checks used when evaluating the health state of the targets in the specified target group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyTargetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyTargetGroupRequest#builder()}
     * </p>
     *
     * @param modifyTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyTargetGroupResponse> modifyTargetGroup(
            Consumer<ModifyTargetGroupRequest.Builder> modifyTargetGroupRequest) {
        return modifyTargetGroup(ModifyTargetGroupRequest.builder().applyMutation(modifyTargetGroupRequest).build());
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified target group.
     * </p>
     *
     * @param modifyTargetGroupAttributesRequest
     * @return A Java Future containing the result of the ModifyTargetGroupAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyTargetGroupAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyTargetGroupAttributesResponse> modifyTargetGroupAttributes(
            ModifyTargetGroupAttributesRequest modifyTargetGroupAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified target group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyTargetGroupAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyTargetGroupAttributesRequest#builder()}
     * </p>
     *
     * @param modifyTargetGroupAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ModifyTargetGroupAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyTargetGroupAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyTargetGroupAttributesResponse> modifyTargetGroupAttributes(
            Consumer<ModifyTargetGroupAttributesRequest.Builder> modifyTargetGroupAttributesRequest) {
        return modifyTargetGroupAttributes(ModifyTargetGroupAttributesRequest.builder()
                .applyMutation(modifyTargetGroupAttributesRequest).build());
    }

    /**
     * <p>
     * Update the ca certificate bundle for the specified trust store.
     * </p>
     *
     * @param modifyTrustStoreRequest
     * @return A Java Future containing the result of the ModifyTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>InvalidCaCertificatesBundleException The specified ca certificate bundle is in an invalid format, or
     *         corrupt.</li>
     *         <li>CaCertificatesBundleNotFoundException The specified ca certificate bundle does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyTrustStoreResponse> modifyTrustStore(ModifyTrustStoreRequest modifyTrustStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the ca certificate bundle for the specified trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyTrustStoreRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyTrustStoreRequest#builder()}
     * </p>
     *
     * @param modifyTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTrustStoreRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>InvalidCaCertificatesBundleException The specified ca certificate bundle is in an invalid format, or
     *         corrupt.</li>
     *         <li>CaCertificatesBundleNotFoundException The specified ca certificate bundle does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyTrustStoreResponse> modifyTrustStore(
            Consumer<ModifyTrustStoreRequest.Builder> modifyTrustStoreRequest) {
        return modifyTrustStore(ModifyTrustStoreRequest.builder().applyMutation(modifyTrustStoreRequest).build());
    }

    /**
     * <p>
     * Registers the specified targets with the specified target group.
     * </p>
     * <p>
     * If the target is an EC2 instance, it must be in the <code>running</code> state when you register it.
     * </p>
     * <p>
     * By default, the load balancer routes requests to registered targets using the protocol and port for the target
     * group. Alternatively, you can override the port for a target when you register it. You can register each EC2
     * instance or IP address with the same target group multiple times using different ports.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/target-group-register-targets.html">
     * Register targets for your Application Load Balancer</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/target-group-register-targets.html">
     * Register targets for your Network Load Balancer</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-group-register-targets.html">
     * Register targets for your Gateway Load Balancer</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param registerTargetsRequest
     * @return A Java Future containing the result of the RegisterTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>InvalidTargetException The specified target does not exist, is not in the same VPC as the target
     *         group, or has an unsupported instance type.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RegisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RegisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterTargetsResponse> registerTargets(RegisterTargetsRequest registerTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the specified targets with the specified target group.
     * </p>
     * <p>
     * If the target is an EC2 instance, it must be in the <code>running</code> state when you register it.
     * </p>
     * <p>
     * By default, the load balancer routes requests to registered targets using the protocol and port for the target
     * group. Alternatively, you can override the port for a target when you register it. You can register each EC2
     * instance or IP address with the same target group multiple times using different ports.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/target-group-register-targets.html">
     * Register targets for your Application Load Balancer</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/target-group-register-targets.html">
     * Register targets for your Network Load Balancer</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-group-register-targets.html">
     * Register targets for your Gateway Load Balancer</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterTargetsRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterTargetsRequest#builder()}
     * </p>
     *
     * @param registerTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RegisterTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>InvalidTargetException The specified target does not exist, is not in the same VPC as the target
     *         group, or has an unsupported instance type.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RegisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RegisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterTargetsResponse> registerTargets(
            Consumer<RegisterTargetsRequest.Builder> registerTargetsRequest) {
        return registerTargets(RegisterTargetsRequest.builder().applyMutation(registerTargetsRequest).build());
    }

    /**
     * <p>
     * Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
     * </p>
     *
     * @param removeListenerCertificatesRequest
     * @return A Java Future containing the result of the RemoveListenerCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RemoveListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveListenerCertificatesResponse> removeListenerCertificates(
            RemoveListenerCertificatesRequest removeListenerCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveListenerCertificatesRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveListenerCertificatesRequest#builder()}
     * </p>
     *
     * @param removeListenerCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RemoveListenerCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RemoveListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveListenerCertificatesResponse> removeListenerCertificates(
            Consumer<RemoveListenerCertificatesRequest.Builder> removeListenerCertificatesRequest) {
        return removeListenerCertificates(RemoveListenerCertificatesRequest.builder()
                .applyMutation(removeListenerCertificatesRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one
     * or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or
     * rules.
     * </p>
     *
     * @param removeTagsRequest
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one
     * or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or
     * rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTagsRequest#builder()}
     * </p>
     *
     * @param removeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(Consumer<RemoveTagsRequest.Builder> removeTagsRequest) {
        return removeTags(RemoveTagsRequest.builder().applyMutation(removeTagsRequest).build());
    }

    /**
     * <p>
     * Removes the specified revocation file from the specified trust store.
     * </p>
     *
     * @param removeTrustStoreRevocationsRequest
     * @return A Java Future containing the result of the RemoveTrustStoreRevocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>RevocationIdNotFoundException The specified revocation ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RemoveTrustStoreRevocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveTrustStoreRevocationsResponse> removeTrustStoreRevocations(
            RemoveTrustStoreRevocationsRequest removeTrustStoreRevocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified revocation file from the specified trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTrustStoreRevocationsRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveTrustStoreRevocationsRequest#builder()}
     * </p>
     *
     * @param removeTrustStoreRevocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTrustStoreRevocationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RemoveTrustStoreRevocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>RevocationIdNotFoundException The specified revocation ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RemoveTrustStoreRevocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveTrustStoreRevocationsResponse> removeTrustStoreRevocations(
            Consumer<RemoveTrustStoreRevocationsRequest.Builder> removeTrustStoreRevocationsRequest) {
        return removeTrustStoreRevocations(RemoveTrustStoreRevocationsRequest.builder()
                .applyMutation(removeTrustStoreRevocationsRequest).build());
    }

    /**
     * <p>
     * Sets the type of IP addresses used by the subnets of the specified load balancer.
     * </p>
     *
     * @param setIpAddressTypeRequest
     * @return A Java Future containing the result of the SetIpAddressType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>InvalidSubnetException The specified subnet is out of available addresses.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetIpAddressType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetIpAddressType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIpAddressTypeResponse> setIpAddressType(SetIpAddressTypeRequest setIpAddressTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the type of IP addresses used by the subnets of the specified load balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetIpAddressTypeRequest.Builder} avoiding the need
     * to create one manually via {@link SetIpAddressTypeRequest#builder()}
     * </p>
     *
     * @param setIpAddressTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SetIpAddressType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>InvalidSubnetException The specified subnet is out of available addresses.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetIpAddressType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetIpAddressType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIpAddressTypeResponse> setIpAddressType(
            Consumer<SetIpAddressTypeRequest.Builder> setIpAddressTypeRequest) {
        return setIpAddressType(SetIpAddressTypeRequest.builder().applyMutation(setIpAddressTypeRequest).build());
    }

    /**
     * <p>
     * Sets the priorities of the specified rules.
     * </p>
     * <p>
     * You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that
     * you do not specify retain their current priority.
     * </p>
     *
     * @param setRulePrioritiesRequest
     * @return A Java Future containing the result of the SetRulePriorities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>PriorityInUseException The specified priority is in use.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetRulePriorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetRulePriorities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetRulePrioritiesResponse> setRulePriorities(SetRulePrioritiesRequest setRulePrioritiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the priorities of the specified rules.
     * </p>
     * <p>
     * You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that
     * you do not specify retain their current priority.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetRulePrioritiesRequest.Builder} avoiding the need
     * to create one manually via {@link SetRulePrioritiesRequest#builder()}
     * </p>
     *
     * @param setRulePrioritiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SetRulePriorities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>PriorityInUseException The specified priority is in use.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetRulePriorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetRulePriorities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetRulePrioritiesResponse> setRulePriorities(
            Consumer<SetRulePrioritiesRequest.Builder> setRulePrioritiesRequest) {
        return setRulePriorities(SetRulePrioritiesRequest.builder().applyMutation(setRulePrioritiesRequest).build());
    }

    /**
     * <p>
     * Associates the specified security groups with the specified Application Load Balancer or Network Load Balancer.
     * The specified security groups override the previously associated security groups.
     * </p>
     * <p>
     * You can't perform this operation on a Network Load Balancer unless you specified a security group for the load
     * balancer when you created it.
     * </p>
     * <p>
     * You can't associate a security group with a Gateway Load Balancer.
     * </p>
     *
     * @param setSecurityGroupsRequest
     * @return A Java Future containing the result of the SetSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>InvalidSecurityGroupException The specified security group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetSecurityGroupsResponse> setSecurityGroups(SetSecurityGroupsRequest setSecurityGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified security groups with the specified Application Load Balancer or Network Load Balancer.
     * The specified security groups override the previously associated security groups.
     * </p>
     * <p>
     * You can't perform this operation on a Network Load Balancer unless you specified a security group for the load
     * balancer when you created it.
     * </p>
     * <p>
     * You can't associate a security group with a Gateway Load Balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetSecurityGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link SetSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param setSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SetSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>InvalidSecurityGroupException The specified security group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetSecurityGroupsResponse> setSecurityGroups(
            Consumer<SetSecurityGroupsRequest.Builder> setSecurityGroupsRequest) {
        return setSecurityGroups(SetSecurityGroupsRequest.builder().applyMutation(setSecurityGroupsRequest).build());
    }

    /**
     * <p>
     * Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer,
     * Network Load Balancer or Gateway Load Balancer. The specified subnets replace the previously enabled subnets.
     * </p>
     *
     * @param setSubnetsRequest
     * @return A Java Future containing the result of the SetSubnets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SubnetNotFoundException The specified subnet does not exist.</li>
     *         <li>InvalidSubnetException The specified subnet is out of available addresses.</li>
     *         <li>AllocationIdNotFoundException The specified allocation ID does not exist.</li>
     *         <li>AvailabilityZoneNotSupportedException The specified Availability Zone is not supported.</li>
     *         <li>CapacityReservationPendingException There is a pending capacity reservation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetSubnetsResponse> setSubnets(SetSubnetsRequest setSubnetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer,
     * Network Load Balancer or Gateway Load Balancer. The specified subnets replace the previously enabled subnets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetSubnetsRequest.Builder} avoiding the need to
     * create one manually via {@link SetSubnetsRequest#builder()}
     * </p>
     *
     * @param setSubnetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetSubnets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SubnetNotFoundException The specified subnet does not exist.</li>
     *         <li>InvalidSubnetException The specified subnet is out of available addresses.</li>
     *         <li>AllocationIdNotFoundException The specified allocation ID does not exist.</li>
     *         <li>AvailabilityZoneNotSupportedException The specified Availability Zone is not supported.</li>
     *         <li>CapacityReservationPendingException There is a pending capacity reservation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetSubnetsResponse> setSubnets(Consumer<SetSubnetsRequest.Builder> setSubnetsRequest) {
        return setSubnets(SetSubnetsRequest.builder().applyMutation(setSubnetsRequest).build());
    }

    /**
     * Create an instance of {@link ElasticLoadBalancingV2AsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link ElasticLoadBalancingV2AsyncWaiter}
     */
    default ElasticLoadBalancingV2AsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default ElasticLoadBalancingV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ElasticLoadBalancingV2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ElasticLoadBalancingV2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ElasticLoadBalancingV2AsyncClient}.
     */
    static ElasticLoadBalancingV2AsyncClientBuilder builder() {
        return new DefaultElasticLoadBalancingV2AsyncClientBuilder();
    }
}
