/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RevocationType {
    CRL("CRL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RevocationType> VALUE_MAP;
    private final String value;

    private RevocationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RevocationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RevocationType> knownValues() {
        EnumSet<RevocationType> knownValues = EnumSet.allOf(RevocationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RevocationType.class, RevocationType::toString);
    }
}

