/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreAssociation;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreAssociationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrustStoreAssociationsResponse
extends ElasticLoadBalancingV2Response
implements ToCopyableBuilder<Builder, DescribeTrustStoreAssociationsResponse> {
    private static final SdkField<List<TrustStoreAssociation>> TRUST_STORE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrustStoreAssociations").getter(DescribeTrustStoreAssociationsResponse.getter(DescribeTrustStoreAssociationsResponse::trustStoreAssociations)).setter(DescribeTrustStoreAssociationsResponse.setter(Builder::trustStoreAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrustStoreAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(DescribeTrustStoreAssociationsResponse.getter(DescribeTrustStoreAssociationsResponse::nextMarker)).setter(DescribeTrustStoreAssociationsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ASSOCIATIONS_FIELD, NEXT_MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTrustStoreAssociationsResponse.memberNameToFieldInitializer();
    private final List<TrustStoreAssociation> trustStoreAssociations;
    private final String nextMarker;

    private DescribeTrustStoreAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.trustStoreAssociations = builder.trustStoreAssociations;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasTrustStoreAssociations() {
        return this.trustStoreAssociations != null && !(this.trustStoreAssociations instanceof SdkAutoConstructList);
    }

    public final List<TrustStoreAssociation> trustStoreAssociations() {
        return this.trustStoreAssociations;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrustStoreAssociations() ? this.trustStoreAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustStoreAssociationsResponse)) {
            return false;
        }
        DescribeTrustStoreAssociationsResponse other = (DescribeTrustStoreAssociationsResponse)((Object)obj);
        return this.hasTrustStoreAssociations() == other.hasTrustStoreAssociations() && Objects.equals(this.trustStoreAssociations(), other.trustStoreAssociations()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrustStoreAssociationsResponse").add("TrustStoreAssociations", this.hasTrustStoreAssociations() ? this.trustStoreAssociations() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustStoreAssociations": {
                return Optional.ofNullable(clazz.cast(this.trustStoreAssociations()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrustStoreAssociations", TRUST_STORE_ASSOCIATIONS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustStoreAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeTrustStoreAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Response.BuilderImpl
    implements Builder {
        private List<TrustStoreAssociation> trustStoreAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustStoreAssociationsResponse model) {
            super(model);
            this.trustStoreAssociations(model.trustStoreAssociations);
            this.nextMarker(model.nextMarker);
        }

        public final List<TrustStoreAssociation.Builder> getTrustStoreAssociations() {
            List<TrustStoreAssociation.Builder> result = TrustStoreAssociationsCopier.copyToBuilder(this.trustStoreAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrustStoreAssociations(Collection<TrustStoreAssociation.BuilderImpl> trustStoreAssociations) {
            this.trustStoreAssociations = TrustStoreAssociationsCopier.copyFromBuilder(trustStoreAssociations);
        }

        @Override
        public final Builder trustStoreAssociations(Collection<TrustStoreAssociation> trustStoreAssociations) {
            this.trustStoreAssociations = TrustStoreAssociationsCopier.copy(trustStoreAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustStoreAssociations(TrustStoreAssociation ... trustStoreAssociations) {
            this.trustStoreAssociations(Arrays.asList(trustStoreAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustStoreAssociations(Consumer<TrustStoreAssociation.Builder> ... trustStoreAssociations) {
            this.trustStoreAssociations(Stream.of(trustStoreAssociations).map(c -> (TrustStoreAssociation)((TrustStoreAssociation.Builder)TrustStoreAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public DescribeTrustStoreAssociationsResponse build() {
            return new DescribeTrustStoreAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticLoadBalancingV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrustStoreAssociationsResponse> {
        public Builder trustStoreAssociations(Collection<TrustStoreAssociation> var1);

        public Builder trustStoreAssociations(TrustStoreAssociation ... var1);

        public Builder trustStoreAssociations(Consumer<TrustStoreAssociation.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

