/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStore;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoresCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrustStoreResponse
extends ElasticLoadBalancingV2Response
implements ToCopyableBuilder<Builder, CreateTrustStoreResponse> {
    private static final SdkField<List<TrustStore>> TRUST_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrustStores").getter(CreateTrustStoreResponse.getter(CreateTrustStoreResponse::trustStores)).setter(CreateTrustStoreResponse.setter(Builder::trustStores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrustStore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTrustStoreResponse.memberNameToFieldInitializer();
    private final List<TrustStore> trustStores;

    private CreateTrustStoreResponse(BuilderImpl builder) {
        super(builder);
        this.trustStores = builder.trustStores;
    }

    public final boolean hasTrustStores() {
        return this.trustStores != null && !(this.trustStores instanceof SdkAutoConstructList);
    }

    public final List<TrustStore> trustStores() {
        return this.trustStores;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrustStores() ? this.trustStores() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustStoreResponse)) {
            return false;
        }
        CreateTrustStoreResponse other = (CreateTrustStoreResponse)((Object)obj);
        return this.hasTrustStores() == other.hasTrustStores() && Objects.equals(this.trustStores(), other.trustStores());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrustStoreResponse").add("TrustStores", this.hasTrustStores() ? this.trustStores() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustStores": {
                return Optional.ofNullable(clazz.cast(this.trustStores()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<TrustStore>>> map = new HashMap<String, SdkField<List<TrustStore>>>();
        map.put("TrustStores", TRUST_STORES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrustStoreResponse, T> g) {
        return obj -> g.apply((CreateTrustStoreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Response.BuilderImpl
    implements Builder {
        private List<TrustStore> trustStores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrustStoreResponse model) {
            super(model);
            this.trustStores(model.trustStores);
        }

        public final List<TrustStore.Builder> getTrustStores() {
            List<TrustStore.Builder> result = TrustStoresCopier.copyToBuilder(this.trustStores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrustStores(Collection<TrustStore.BuilderImpl> trustStores) {
            this.trustStores = TrustStoresCopier.copyFromBuilder(trustStores);
        }

        @Override
        public final Builder trustStores(Collection<TrustStore> trustStores) {
            this.trustStores = TrustStoresCopier.copy(trustStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustStores(TrustStore ... trustStores) {
            this.trustStores(Arrays.asList(trustStores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustStores(Consumer<TrustStore.Builder> ... trustStores) {
            this.trustStores(Stream.of(trustStores).map(c -> (TrustStore)((TrustStore.Builder)TrustStore.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateTrustStoreResponse build() {
            return new CreateTrustStoreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticLoadBalancingV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrustStoreResponse> {
        public Builder trustStores(Collection<TrustStore> var1);

        public Builder trustStores(TrustStore ... var1);

        public Builder trustStores(Consumer<TrustStore.Builder> ... var1);
    }
}

