/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSslPoliciesResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<DescribeSslPoliciesResponse.Builder, DescribeSslPoliciesResponse> {
    private static final SdkField<List<SslPolicy>> SSL_POLICIES_FIELD = SdkField
            .<List<SslPolicy>> builder(MarshallingType.LIST)
            .memberName("SslPolicies")
            .getter(getter(DescribeSslPoliciesResponse::sslPolicies))
            .setter(setter(Builder::sslPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SslPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(SslPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(DescribeSslPoliciesResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSL_POLICIES_FIELD,
            NEXT_MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SslPolicy> sslPolicies;

    private final String nextMarker;

    private DescribeSslPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.sslPolicies = builder.sslPolicies;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the SslPolicies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSslPolicies() {
        return sslPolicies != null && !(sslPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the security policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSslPolicies} method.
     * </p>
     * 
     * @return Information about the security policies.
     */
    public final List<SslPolicy> sslPolicies() {
        return sslPolicies;
    }

    /**
     * <p>
     * If there are additional results, this is the marker for the next set of results. Otherwise, this is null.
     * </p>
     * 
     * @return If there are additional results, this is the marker for the next set of results. Otherwise, this is null.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSslPolicies() ? sslPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSslPoliciesResponse)) {
            return false;
        }
        DescribeSslPoliciesResponse other = (DescribeSslPoliciesResponse) obj;
        return hasSslPolicies() == other.hasSslPolicies() && Objects.equals(sslPolicies(), other.sslPolicies())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSslPoliciesResponse").add("SslPolicies", hasSslPolicies() ? sslPolicies() : null)
                .add("NextMarker", nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SslPolicies":
            return Optional.ofNullable(clazz.cast(sslPolicies()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SslPolicies", SSL_POLICIES_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSslPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeSslPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSslPoliciesResponse> {
        /**
         * <p>
         * Information about the security policies.
         * </p>
         * 
         * @param sslPolicies
         *        Information about the security policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslPolicies(Collection<SslPolicy> sslPolicies);

        /**
         * <p>
         * Information about the security policies.
         * </p>
         * 
         * @param sslPolicies
         *        Information about the security policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslPolicies(SslPolicy... sslPolicies);

        /**
         * <p>
         * Information about the security policies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #sslPolicies(List<SslPolicy>)}.
         * 
         * @param sslPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sslPolicies(java.util.Collection<SslPolicy>)
         */
        Builder sslPolicies(Consumer<SslPolicy.Builder>... sslPolicies);

        /**
         * <p>
         * If there are additional results, this is the marker for the next set of results. Otherwise, this is null.
         * </p>
         * 
         * @param nextMarker
         *        If there are additional results, this is the marker for the next set of results. Otherwise, this is
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private List<SslPolicy> sslPolicies = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSslPoliciesResponse model) {
            super(model);
            sslPolicies(model.sslPolicies);
            nextMarker(model.nextMarker);
        }

        public final List<SslPolicy.Builder> getSslPolicies() {
            List<SslPolicy.Builder> result = SslPoliciesCopier.copyToBuilder(this.sslPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSslPolicies(Collection<SslPolicy.BuilderImpl> sslPolicies) {
            this.sslPolicies = SslPoliciesCopier.copyFromBuilder(sslPolicies);
        }

        @Override
        public final Builder sslPolicies(Collection<SslPolicy> sslPolicies) {
            this.sslPolicies = SslPoliciesCopier.copy(sslPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sslPolicies(SslPolicy... sslPolicies) {
            sslPolicies(Arrays.asList(sslPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sslPolicies(Consumer<SslPolicy.Builder>... sslPolicies) {
            sslPolicies(Stream.of(sslPolicies).map(c -> SslPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public DescribeSslPoliciesResponse build() {
            return new DescribeSslPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
