/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetSecurityGroupsResponse
extends ElasticLoadBalancingV2Response
implements ToCopyableBuilder<Builder, SetSecurityGroupsResponse> {
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(SetSecurityGroupsResponse.getter(SetSecurityGroupsResponse::securityGroupIds)).setter(SetSecurityGroupsResponse.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENFORCE_SECURITY_GROUP_INBOUND_RULES_ON_PRIVATE_LINK_TRAFFIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic").getter(SetSecurityGroupsResponse.getter(SetSecurityGroupsResponse::enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString)).setter(SetSecurityGroupsResponse.setter(Builder::enforceSecurityGroupInboundRulesOnPrivateLinkTraffic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_IDS_FIELD, ENFORCE_SECURITY_GROUP_INBOUND_RULES_ON_PRIVATE_LINK_TRAFFIC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SetSecurityGroupsResponse.memberNameToFieldInitializer();
    private final List<String> securityGroupIds;
    private final String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;

    private SetSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.securityGroupIds = builder.securityGroupIds;
        this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = builder.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum enforceSecurityGroupInboundRulesOnPrivateLinkTraffic() {
        return EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum.fromValue(this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);
    }

    public final String enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString() {
        return this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSecurityGroupsResponse)) {
            return false;
        }
        SetSecurityGroupsResponse other = (SetSecurityGroupsResponse)((Object)obj);
        return this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString(), other.enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SetSecurityGroupsResponse").add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic", (Object)this.enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic": {
                return Optional.ofNullable(clazz.cast(this.enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic", ENFORCE_SECURITY_GROUP_INBOUND_RULES_ON_PRIVATE_LINK_TRAFFIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetSecurityGroupsResponse, T> g) {
        return obj -> g.apply((SetSecurityGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Response.BuilderImpl
    implements Builder {
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSecurityGroupsResponse model) {
            super(model);
            this.securityGroupIds(model.securityGroupIds);
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(model.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic() {
            return this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        }

        public final void setEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic(String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        }

        @Override
        public final Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
            return this;
        }

        @Override
        public final Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(enforceSecurityGroupInboundRulesOnPrivateLinkTraffic == null ? null : enforceSecurityGroupInboundRulesOnPrivateLinkTraffic.toString());
            return this;
        }

        @Override
        public SetSecurityGroupsResponse build() {
            return new SetSecurityGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticLoadBalancingV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetSecurityGroupsResponse> {
        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(String var1);

        public Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum var1);
    }
}

