/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCapacityReservationRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<ModifyCapacityReservationRequest.Builder, ModifyCapacityReservationRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerArn").getter(getter(ModifyCapacityReservationRequest::loadBalancerArn))
            .setter(setter(Builder::loadBalancerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()).build();

    private static final SdkField<MinimumLoadBalancerCapacity> MINIMUM_LOAD_BALANCER_CAPACITY_FIELD = SdkField
            .<MinimumLoadBalancerCapacity> builder(MarshallingType.SDK_POJO)
            .memberName("MinimumLoadBalancerCapacity")
            .getter(getter(ModifyCapacityReservationRequest::minimumLoadBalancerCapacity))
            .setter(setter(Builder::minimumLoadBalancerCapacity))
            .constructor(MinimumLoadBalancerCapacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumLoadBalancerCapacity")
                    .build()).build();

    private static final SdkField<Boolean> RESET_CAPACITY_RESERVATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ResetCapacityReservation").getter(getter(ModifyCapacityReservationRequest::resetCapacityReservation))
            .setter(setter(Builder::resetCapacityReservation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetCapacityReservation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD,
            MINIMUM_LOAD_BALANCER_CAPACITY_FIELD, RESET_CAPACITY_RESERVATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String loadBalancerArn;

    private final MinimumLoadBalancerCapacity minimumLoadBalancerCapacity;

    private final Boolean resetCapacityReservation;

    private ModifyCapacityReservationRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.minimumLoadBalancerCapacity = builder.minimumLoadBalancerCapacity;
        this.resetCapacityReservation = builder.resetCapacityReservation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the load balancer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the load balancer.
     */
    public final String loadBalancerArn() {
        return loadBalancerArn;
    }

    /**
     * <p>
     * The minimum load balancer capacity reserved.
     * </p>
     * 
     * @return The minimum load balancer capacity reserved.
     */
    public final MinimumLoadBalancerCapacity minimumLoadBalancerCapacity() {
        return minimumLoadBalancerCapacity;
    }

    /**
     * <p>
     * Resets the capacity reservation.
     * </p>
     * 
     * @return Resets the capacity reservation.
     */
    public final Boolean resetCapacityReservation() {
        return resetCapacityReservation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(minimumLoadBalancerCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(resetCapacityReservation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCapacityReservationRequest)) {
            return false;
        }
        ModifyCapacityReservationRequest other = (ModifyCapacityReservationRequest) obj;
        return Objects.equals(loadBalancerArn(), other.loadBalancerArn())
                && Objects.equals(minimumLoadBalancerCapacity(), other.minimumLoadBalancerCapacity())
                && Objects.equals(resetCapacityReservation(), other.resetCapacityReservation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCapacityReservationRequest").add("LoadBalancerArn", loadBalancerArn())
                .add("MinimumLoadBalancerCapacity", minimumLoadBalancerCapacity())
                .add("ResetCapacityReservation", resetCapacityReservation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerArn":
            return Optional.ofNullable(clazz.cast(loadBalancerArn()));
        case "MinimumLoadBalancerCapacity":
            return Optional.ofNullable(clazz.cast(minimumLoadBalancerCapacity()));
        case "ResetCapacityReservation":
            return Optional.ofNullable(clazz.cast(resetCapacityReservation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LoadBalancerArn", LOAD_BALANCER_ARN_FIELD);
        map.put("MinimumLoadBalancerCapacity", MINIMUM_LOAD_BALANCER_CAPACITY_FIELD);
        map.put("ResetCapacityReservation", RESET_CAPACITY_RESERVATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyCapacityReservationRequest, T> g) {
        return obj -> g.apply((ModifyCapacityReservationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyCapacityReservationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the load balancer.
         * </p>
         * 
         * @param loadBalancerArn
         *        The Amazon Resource Name (ARN) of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArn(String loadBalancerArn);

        /**
         * <p>
         * The minimum load balancer capacity reserved.
         * </p>
         * 
         * @param minimumLoadBalancerCapacity
         *        The minimum load balancer capacity reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity minimumLoadBalancerCapacity);

        /**
         * <p>
         * The minimum load balancer capacity reserved.
         * </p>
         * This is a convenience method that creates an instance of the {@link MinimumLoadBalancerCapacity.Builder}
         * avoiding the need to create one manually via {@link MinimumLoadBalancerCapacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MinimumLoadBalancerCapacity.Builder#build()} is called
         * immediately and its result is passed to {@link #minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity)}.
         * 
         * @param minimumLoadBalancerCapacity
         *        a consumer that will call methods on {@link MinimumLoadBalancerCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity)
         */
        default Builder minimumLoadBalancerCapacity(Consumer<MinimumLoadBalancerCapacity.Builder> minimumLoadBalancerCapacity) {
            return minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity.builder().applyMutation(minimumLoadBalancerCapacity)
                    .build());
        }

        /**
         * <p>
         * Resets the capacity reservation.
         * </p>
         * 
         * @param resetCapacityReservation
         *        Resets the capacity reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetCapacityReservation(Boolean resetCapacityReservation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String loadBalancerArn;

        private MinimumLoadBalancerCapacity minimumLoadBalancerCapacity;

        private Boolean resetCapacityReservation;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCapacityReservationRequest model) {
            super(model);
            loadBalancerArn(model.loadBalancerArn);
            minimumLoadBalancerCapacity(model.minimumLoadBalancerCapacity);
            resetCapacityReservation(model.resetCapacityReservation);
        }

        public final String getLoadBalancerArn() {
            return loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final MinimumLoadBalancerCapacity.Builder getMinimumLoadBalancerCapacity() {
            return minimumLoadBalancerCapacity != null ? minimumLoadBalancerCapacity.toBuilder() : null;
        }

        public final void setMinimumLoadBalancerCapacity(MinimumLoadBalancerCapacity.BuilderImpl minimumLoadBalancerCapacity) {
            this.minimumLoadBalancerCapacity = minimumLoadBalancerCapacity != null ? minimumLoadBalancerCapacity.build() : null;
        }

        @Override
        public final Builder minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity minimumLoadBalancerCapacity) {
            this.minimumLoadBalancerCapacity = minimumLoadBalancerCapacity;
            return this;
        }

        public final Boolean getResetCapacityReservation() {
            return resetCapacityReservation;
        }

        public final void setResetCapacityReservation(Boolean resetCapacityReservation) {
            this.resetCapacityReservation = resetCapacityReservation;
        }

        @Override
        public final Builder resetCapacityReservation(Boolean resetCapacityReservation) {
            this.resetCapacityReservation = resetCapacityReservation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCapacityReservationRequest build() {
            return new ModifyCapacityReservationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
