/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationContent;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationContentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddTrustStoreRevocationsRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, AddTrustStoreRevocationsRequest> {
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustStoreArn").getter(AddTrustStoreRevocationsRequest.getter(AddTrustStoreRevocationsRequest::trustStoreArn)).setter(AddTrustStoreRevocationsRequest.setter(Builder::trustStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()}).build();
    private static final SdkField<List<RevocationContent>> REVOCATION_CONTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RevocationContents").getter(AddTrustStoreRevocationsRequest.getter(AddTrustStoreRevocationsRequest::revocationContents)).setter(AddTrustStoreRevocationsRequest.setter(Builder::revocationContents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationContents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RevocationContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ARN_FIELD, REVOCATION_CONTENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddTrustStoreRevocationsRequest.memberNameToFieldInitializer();
    private final String trustStoreArn;
    private final List<RevocationContent> revocationContents;

    private AddTrustStoreRevocationsRequest(BuilderImpl builder) {
        super(builder);
        this.trustStoreArn = builder.trustStoreArn;
        this.revocationContents = builder.revocationContents;
    }

    public final String trustStoreArn() {
        return this.trustStoreArn;
    }

    public final boolean hasRevocationContents() {
        return this.revocationContents != null && !(this.revocationContents instanceof SdkAutoConstructList);
    }

    public final List<RevocationContent> revocationContents() {
        return this.revocationContents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevocationContents() ? this.revocationContents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTrustStoreRevocationsRequest)) {
            return false;
        }
        AddTrustStoreRevocationsRequest other = (AddTrustStoreRevocationsRequest)((Object)obj);
        return Objects.equals(this.trustStoreArn(), other.trustStoreArn()) && this.hasRevocationContents() == other.hasRevocationContents() && Objects.equals(this.revocationContents(), other.revocationContents());
    }

    public final String toString() {
        return ToString.builder((String)"AddTrustStoreRevocationsRequest").add("TrustStoreArn", (Object)this.trustStoreArn()).add("RevocationContents", this.hasRevocationContents() ? this.revocationContents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustStoreArn": {
                return Optional.ofNullable(clazz.cast(this.trustStoreArn()));
            }
            case "RevocationContents": {
                return Optional.ofNullable(clazz.cast(this.revocationContents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrustStoreArn", TRUST_STORE_ARN_FIELD);
        map.put("RevocationContents", REVOCATION_CONTENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddTrustStoreRevocationsRequest, T> g) {
        return obj -> g.apply((AddTrustStoreRevocationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String trustStoreArn;
        private List<RevocationContent> revocationContents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddTrustStoreRevocationsRequest model) {
            super(model);
            this.trustStoreArn(model.trustStoreArn);
            this.revocationContents(model.revocationContents);
        }

        public final String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final List<RevocationContent.Builder> getRevocationContents() {
            List<RevocationContent.Builder> result = RevocationContentsCopier.copyToBuilder(this.revocationContents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevocationContents(Collection<RevocationContent.BuilderImpl> revocationContents) {
            this.revocationContents = RevocationContentsCopier.copyFromBuilder(revocationContents);
        }

        @Override
        public final Builder revocationContents(Collection<RevocationContent> revocationContents) {
            this.revocationContents = RevocationContentsCopier.copy(revocationContents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revocationContents(RevocationContent ... revocationContents) {
            this.revocationContents(Arrays.asList(revocationContents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revocationContents(Consumer<RevocationContent.Builder> ... revocationContents) {
            this.revocationContents(Stream.of(revocationContents).map(c -> (RevocationContent)((RevocationContent.Builder)RevocationContent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddTrustStoreRevocationsRequest build() {
            return new AddTrustStoreRevocationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddTrustStoreRevocationsRequest> {
        public Builder trustStoreArn(String var1);

        public Builder revocationContents(Collection<RevocationContent> var1);

        public Builder revocationContents(RevocationContent ... var1);

        public Builder revocationContents(Consumer<RevocationContent.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

