/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrustStore
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrustStore> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TrustStore.getter(TrustStore::name)).setter(TrustStore.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustStoreArn").getter(TrustStore.getter(TrustStore::trustStoreArn)).setter(TrustStore.setter(Builder::trustStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TrustStore.getter(TrustStore::statusAsString)).setter(TrustStore.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_CA_CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfCaCertificates").getter(TrustStore.getter(TrustStore::numberOfCaCertificates)).setter(TrustStore.setter(Builder::numberOfCaCertificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfCaCertificates").build()}).build();
    private static final SdkField<Long> TOTAL_REVOKED_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalRevokedEntries").getter(TrustStore.getter(TrustStore::totalRevokedEntries)).setter(TrustStore.setter(Builder::totalRevokedEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRevokedEntries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TRUST_STORE_ARN_FIELD, STATUS_FIELD, NUMBER_OF_CA_CERTIFICATES_FIELD, TOTAL_REVOKED_ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrustStore.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String trustStoreArn;
    private final String status;
    private final Integer numberOfCaCertificates;
    private final Long totalRevokedEntries;

    private TrustStore(BuilderImpl builder) {
        this.name = builder.name;
        this.trustStoreArn = builder.trustStoreArn;
        this.status = builder.status;
        this.numberOfCaCertificates = builder.numberOfCaCertificates;
        this.totalRevokedEntries = builder.totalRevokedEntries;
    }

    public final String name() {
        return this.name;
    }

    public final String trustStoreArn() {
        return this.trustStoreArn;
    }

    public final TrustStoreStatus status() {
        return TrustStoreStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer numberOfCaCertificates() {
        return this.numberOfCaCertificates;
    }

    public final Long totalRevokedEntries() {
        return this.totalRevokedEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfCaCertificates());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRevokedEntries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustStore)) {
            return false;
        }
        TrustStore other = (TrustStore)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.trustStoreArn(), other.trustStoreArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.numberOfCaCertificates(), other.numberOfCaCertificates()) && Objects.equals(this.totalRevokedEntries(), other.totalRevokedEntries());
    }

    public final String toString() {
        return ToString.builder((String)"TrustStore").add("Name", (Object)this.name()).add("TrustStoreArn", (Object)this.trustStoreArn()).add("Status", (Object)this.statusAsString()).add("NumberOfCaCertificates", (Object)this.numberOfCaCertificates()).add("TotalRevokedEntries", (Object)this.totalRevokedEntries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TrustStoreArn": {
                return Optional.ofNullable(clazz.cast(this.trustStoreArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NumberOfCaCertificates": {
                return Optional.ofNullable(clazz.cast(this.numberOfCaCertificates()));
            }
            case "TotalRevokedEntries": {
                return Optional.ofNullable(clazz.cast(this.totalRevokedEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("TrustStoreArn", TRUST_STORE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("NumberOfCaCertificates", NUMBER_OF_CA_CERTIFICATES_FIELD);
        map.put("TotalRevokedEntries", TOTAL_REVOKED_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrustStore, T> g) {
        return obj -> g.apply((TrustStore)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String trustStoreArn;
        private String status;
        private Integer numberOfCaCertificates;
        private Long totalRevokedEntries;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustStore model) {
            this.name(model.name);
            this.trustStoreArn(model.trustStoreArn);
            this.status(model.status);
            this.numberOfCaCertificates(model.numberOfCaCertificates);
            this.totalRevokedEntries(model.totalRevokedEntries);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrustStoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getNumberOfCaCertificates() {
            return this.numberOfCaCertificates;
        }

        public final void setNumberOfCaCertificates(Integer numberOfCaCertificates) {
            this.numberOfCaCertificates = numberOfCaCertificates;
        }

        @Override
        public final Builder numberOfCaCertificates(Integer numberOfCaCertificates) {
            this.numberOfCaCertificates = numberOfCaCertificates;
            return this;
        }

        public final Long getTotalRevokedEntries() {
            return this.totalRevokedEntries;
        }

        public final void setTotalRevokedEntries(Long totalRevokedEntries) {
            this.totalRevokedEntries = totalRevokedEntries;
        }

        @Override
        public final Builder totalRevokedEntries(Long totalRevokedEntries) {
            this.totalRevokedEntries = totalRevokedEntries;
            return this;
        }

        public TrustStore build() {
            return new TrustStore(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrustStore> {
        public Builder name(String var1);

        public Builder trustStoreArn(String var1);

        public Builder status(String var1);

        public Builder status(TrustStoreStatus var1);

        public Builder numberOfCaCertificates(Integer var1);

        public Builder totalRevokedEntries(Long var1);
    }
}

