/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;

public class DescribeLoadBalancersIterable
implements SdkIterable<DescribeLoadBalancersResponse> {
    private final ElasticLoadBalancingV2Client client;
    private final DescribeLoadBalancersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLoadBalancersIterable(ElasticLoadBalancingV2Client client, DescribeLoadBalancersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeLoadBalancersResponseFetcher();
    }

    public Iterator<DescribeLoadBalancersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LoadBalancer> loadBalancers() {
        Function<DescribeLoadBalancersResponse, Iterator> getIterator = response -> {
            if (response != null && response.loadBalancers() != null) {
                return response.loadBalancers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeLoadBalancersIterable resume(DescribeLoadBalancersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeLoadBalancersIterable(this.client, (DescribeLoadBalancersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new DescribeLoadBalancersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeLoadBalancersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeLoadBalancersResponseFetcher
    implements SyncPageFetcher<DescribeLoadBalancersResponse> {
        private DescribeLoadBalancersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLoadBalancersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public DescribeLoadBalancersResponse nextPage(DescribeLoadBalancersResponse previousPage) {
            if (previousPage == null) {
                return DescribeLoadBalancersIterable.this.client.describeLoadBalancers(DescribeLoadBalancersIterable.this.firstRequest);
            }
            return DescribeLoadBalancersIterable.this.client.describeLoadBalancers((DescribeLoadBalancersRequest)((Object)DescribeLoadBalancersIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

