/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetAdministrativeOverrideReasonEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetAdministrativeOverrideStateEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdministrativeOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdministrativeOverride> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AdministrativeOverride.getter(AdministrativeOverride::stateAsString)).setter(AdministrativeOverride.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(AdministrativeOverride.getter(AdministrativeOverride::reasonAsString)).setter(AdministrativeOverride.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AdministrativeOverride.getter(AdministrativeOverride::description)).setter(AdministrativeOverride.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, REASON_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AdministrativeOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String state;
    private final String reason;
    private final String description;

    private AdministrativeOverride(BuilderImpl builder) {
        this.state = builder.state;
        this.reason = builder.reason;
        this.description = builder.description;
    }

    public final TargetAdministrativeOverrideStateEnum state() {
        return TargetAdministrativeOverrideStateEnum.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final TargetAdministrativeOverrideReasonEnum reason() {
        return TargetAdministrativeOverrideReasonEnum.fromValue(this.reason);
    }

    public final String reasonAsString() {
        return this.reason;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdministrativeOverride)) {
            return false;
        }
        AdministrativeOverride other = (AdministrativeOverride)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.reasonAsString(), other.reasonAsString()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"AdministrativeOverride").add("State", (Object)this.stateAsString()).add("Reason", (Object)this.reasonAsString()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("State", STATE_FIELD);
        map.put("Reason", REASON_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdministrativeOverride, T> g) {
        return obj -> g.apply((AdministrativeOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String reason;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AdministrativeOverride model) {
            this.state(model.state);
            this.reason(model.reason);
            this.description(model.description);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TargetAdministrativeOverrideStateEnum state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(TargetAdministrativeOverrideReasonEnum reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public AdministrativeOverride build() {
            return new AdministrativeOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdministrativeOverride> {
        public Builder state(String var1);

        public Builder state(TargetAdministrativeOverrideStateEnum var1);

        public Builder reason(String var1);

        public Builder reason(TargetAdministrativeOverrideReasonEnum var1);

        public Builder description(String var1);
    }
}

