/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrustStoreRevocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeTrustStoreRevocation> {
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustStoreArn").getter(DescribeTrustStoreRevocation.getter(DescribeTrustStoreRevocation::trustStoreArn)).setter(DescribeTrustStoreRevocation.setter(Builder::trustStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()}).build();
    private static final SdkField<Long> REVOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RevocationId").getter(DescribeTrustStoreRevocation.getter(DescribeTrustStoreRevocation::revocationId)).setter(DescribeTrustStoreRevocation.setter(Builder::revocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationId").build()}).build();
    private static final SdkField<String> REVOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevocationType").getter(DescribeTrustStoreRevocation.getter(DescribeTrustStoreRevocation::revocationTypeAsString)).setter(DescribeTrustStoreRevocation.setter(Builder::revocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationType").build()}).build();
    private static final SdkField<Long> NUMBER_OF_REVOKED_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfRevokedEntries").getter(DescribeTrustStoreRevocation.getter(DescribeTrustStoreRevocation::numberOfRevokedEntries)).setter(DescribeTrustStoreRevocation.setter(Builder::numberOfRevokedEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfRevokedEntries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ARN_FIELD, REVOCATION_ID_FIELD, REVOCATION_TYPE_FIELD, NUMBER_OF_REVOKED_ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTrustStoreRevocation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trustStoreArn;
    private final Long revocationId;
    private final String revocationType;
    private final Long numberOfRevokedEntries;

    private DescribeTrustStoreRevocation(BuilderImpl builder) {
        this.trustStoreArn = builder.trustStoreArn;
        this.revocationId = builder.revocationId;
        this.revocationType = builder.revocationType;
        this.numberOfRevokedEntries = builder.numberOfRevokedEntries;
    }

    public final String trustStoreArn() {
        return this.trustStoreArn;
    }

    public final Long revocationId() {
        return this.revocationId;
    }

    public final RevocationType revocationType() {
        return RevocationType.fromValue(this.revocationType);
    }

    public final String revocationTypeAsString() {
        return this.revocationType;
    }

    public final Long numberOfRevokedEntries() {
        return this.numberOfRevokedEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRevokedEntries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustStoreRevocation)) {
            return false;
        }
        DescribeTrustStoreRevocation other = (DescribeTrustStoreRevocation)obj;
        return Objects.equals(this.trustStoreArn(), other.trustStoreArn()) && Objects.equals(this.revocationId(), other.revocationId()) && Objects.equals(this.revocationTypeAsString(), other.revocationTypeAsString()) && Objects.equals(this.numberOfRevokedEntries(), other.numberOfRevokedEntries());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrustStoreRevocation").add("TrustStoreArn", (Object)this.trustStoreArn()).add("RevocationId", (Object)this.revocationId()).add("RevocationType", (Object)this.revocationTypeAsString()).add("NumberOfRevokedEntries", (Object)this.numberOfRevokedEntries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustStoreArn": {
                return Optional.ofNullable(clazz.cast(this.trustStoreArn()));
            }
            case "RevocationId": {
                return Optional.ofNullable(clazz.cast(this.revocationId()));
            }
            case "RevocationType": {
                return Optional.ofNullable(clazz.cast(this.revocationTypeAsString()));
            }
            case "NumberOfRevokedEntries": {
                return Optional.ofNullable(clazz.cast(this.numberOfRevokedEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrustStoreArn", TRUST_STORE_ARN_FIELD);
        map.put("RevocationId", REVOCATION_ID_FIELD);
        map.put("RevocationType", REVOCATION_TYPE_FIELD);
        map.put("NumberOfRevokedEntries", NUMBER_OF_REVOKED_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustStoreRevocation, T> g) {
        return obj -> g.apply((DescribeTrustStoreRevocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trustStoreArn;
        private Long revocationId;
        private String revocationType;
        private Long numberOfRevokedEntries;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustStoreRevocation model) {
            this.trustStoreArn(model.trustStoreArn);
            this.revocationId(model.revocationId);
            this.revocationType(model.revocationType);
            this.numberOfRevokedEntries(model.numberOfRevokedEntries);
        }

        public final String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final Long getRevocationId() {
            return this.revocationId;
        }

        public final void setRevocationId(Long revocationId) {
            this.revocationId = revocationId;
        }

        @Override
        public final Builder revocationId(Long revocationId) {
            this.revocationId = revocationId;
            return this;
        }

        public final String getRevocationType() {
            return this.revocationType;
        }

        public final void setRevocationType(String revocationType) {
            this.revocationType = revocationType;
        }

        @Override
        public final Builder revocationType(String revocationType) {
            this.revocationType = revocationType;
            return this;
        }

        @Override
        public final Builder revocationType(RevocationType revocationType) {
            this.revocationType(revocationType == null ? null : revocationType.toString());
            return this;
        }

        public final Long getNumberOfRevokedEntries() {
            return this.numberOfRevokedEntries;
        }

        public final void setNumberOfRevokedEntries(Long numberOfRevokedEntries) {
            this.numberOfRevokedEntries = numberOfRevokedEntries;
        }

        @Override
        public final Builder numberOfRevokedEntries(Long numberOfRevokedEntries) {
            this.numberOfRevokedEntries = numberOfRevokedEntries;
            return this;
        }

        public DescribeTrustStoreRevocation build() {
            return new DescribeTrustStoreRevocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeTrustStoreRevocation> {
        public Builder trustStoreArn(String var1);

        public Builder revocationId(Long var1);

        public Builder revocationType(String var1);

        public Builder revocationType(RevocationType var1);

        public Builder numberOfRevokedEntries(Long var1);
    }
}

