/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AdministrativeOverride;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AnomalyDetection;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetHealthDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetHealthDescription> {
    private static final SdkField<TargetDescription> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Target").getter(TargetHealthDescription.getter(TargetHealthDescription::target)).setter(TargetHealthDescription.setter(Builder::target)).constructor(TargetDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckPort").getter(TargetHealthDescription.getter(TargetHealthDescription::healthCheckPort)).setter(TargetHealthDescription.setter(Builder::healthCheckPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPort").build()}).build();
    private static final SdkField<TargetHealth> TARGET_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetHealth").getter(TargetHealthDescription.getter(TargetHealthDescription::targetHealth)).setter(TargetHealthDescription.setter(Builder::targetHealth)).constructor(TargetHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetHealth").build()}).build();
    private static final SdkField<AnomalyDetection> ANOMALY_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyDetection").getter(TargetHealthDescription.getter(TargetHealthDescription::anomalyDetection)).setter(TargetHealthDescription.setter(Builder::anomalyDetection)).constructor(AnomalyDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetection").build()}).build();
    private static final SdkField<AdministrativeOverride> ADMINISTRATIVE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdministrativeOverride").getter(TargetHealthDescription.getter(TargetHealthDescription::administrativeOverride)).setter(TargetHealthDescription.setter(Builder::administrativeOverride)).constructor(AdministrativeOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrativeOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, HEALTH_CHECK_PORT_FIELD, TARGET_HEALTH_FIELD, ANOMALY_DETECTION_FIELD, ADMINISTRATIVE_OVERRIDE_FIELD));
    private static final long serialVersionUID = 1L;
    private final TargetDescription target;
    private final String healthCheckPort;
    private final TargetHealth targetHealth;
    private final AnomalyDetection anomalyDetection;
    private final AdministrativeOverride administrativeOverride;

    private TargetHealthDescription(BuilderImpl builder) {
        this.target = builder.target;
        this.healthCheckPort = builder.healthCheckPort;
        this.targetHealth = builder.targetHealth;
        this.anomalyDetection = builder.anomalyDetection;
        this.administrativeOverride = builder.administrativeOverride;
    }

    public final TargetDescription target() {
        return this.target;
    }

    public final String healthCheckPort() {
        return this.healthCheckPort;
    }

    public final TargetHealth targetHealth() {
        return this.targetHealth;
    }

    public final AnomalyDetection anomalyDetection() {
        return this.anomalyDetection;
    }

    public final AdministrativeOverride administrativeOverride() {
        return this.administrativeOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetHealth());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetection());
        hashCode = 31 * hashCode + Objects.hashCode(this.administrativeOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetHealthDescription)) {
            return false;
        }
        TargetHealthDescription other = (TargetHealthDescription)obj;
        return Objects.equals(this.target(), other.target()) && Objects.equals(this.healthCheckPort(), other.healthCheckPort()) && Objects.equals(this.targetHealth(), other.targetHealth()) && Objects.equals(this.anomalyDetection(), other.anomalyDetection()) && Objects.equals(this.administrativeOverride(), other.administrativeOverride());
    }

    public final String toString() {
        return ToString.builder((String)"TargetHealthDescription").add("Target", (Object)this.target()).add("HealthCheckPort", (Object)this.healthCheckPort()).add("TargetHealth", (Object)this.targetHealth()).add("AnomalyDetection", (Object)this.anomalyDetection()).add("AdministrativeOverride", (Object)this.administrativeOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "HealthCheckPort": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPort()));
            }
            case "TargetHealth": {
                return Optional.ofNullable(clazz.cast(this.targetHealth()));
            }
            case "AnomalyDetection": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetection()));
            }
            case "AdministrativeOverride": {
                return Optional.ofNullable(clazz.cast(this.administrativeOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetHealthDescription, T> g) {
        return obj -> g.apply((TargetHealthDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TargetDescription target;
        private String healthCheckPort;
        private TargetHealth targetHealth;
        private AnomalyDetection anomalyDetection;
        private AdministrativeOverride administrativeOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetHealthDescription model) {
            this.target(model.target);
            this.healthCheckPort(model.healthCheckPort);
            this.targetHealth(model.targetHealth);
            this.anomalyDetection(model.anomalyDetection);
            this.administrativeOverride(model.administrativeOverride);
        }

        public final TargetDescription.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(TargetDescription.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(TargetDescription target) {
            this.target = target;
            return this;
        }

        public final String getHealthCheckPort() {
            return this.healthCheckPort;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final TargetHealth.Builder getTargetHealth() {
            return this.targetHealth != null ? this.targetHealth.toBuilder() : null;
        }

        public final void setTargetHealth(TargetHealth.BuilderImpl targetHealth) {
            this.targetHealth = targetHealth != null ? targetHealth.build() : null;
        }

        @Override
        public final Builder targetHealth(TargetHealth targetHealth) {
            this.targetHealth = targetHealth;
            return this;
        }

        public final AnomalyDetection.Builder getAnomalyDetection() {
            return this.anomalyDetection != null ? this.anomalyDetection.toBuilder() : null;
        }

        public final void setAnomalyDetection(AnomalyDetection.BuilderImpl anomalyDetection) {
            this.anomalyDetection = anomalyDetection != null ? anomalyDetection.build() : null;
        }

        @Override
        public final Builder anomalyDetection(AnomalyDetection anomalyDetection) {
            this.anomalyDetection = anomalyDetection;
            return this;
        }

        public final AdministrativeOverride.Builder getAdministrativeOverride() {
            return this.administrativeOverride != null ? this.administrativeOverride.toBuilder() : null;
        }

        public final void setAdministrativeOverride(AdministrativeOverride.BuilderImpl administrativeOverride) {
            this.administrativeOverride = administrativeOverride != null ? administrativeOverride.build() : null;
        }

        @Override
        public final Builder administrativeOverride(AdministrativeOverride administrativeOverride) {
            this.administrativeOverride = administrativeOverride;
            return this;
        }

        public TargetHealthDescription build() {
            return new TargetHealthDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetHealthDescription> {
        public Builder target(TargetDescription var1);

        default public Builder target(Consumer<TargetDescription.Builder> target) {
            return this.target((TargetDescription)((TargetDescription.Builder)TargetDescription.builder().applyMutation(target)).build());
        }

        public Builder healthCheckPort(String var1);

        public Builder targetHealth(TargetHealth var1);

        default public Builder targetHealth(Consumer<TargetHealth.Builder> targetHealth) {
            return this.targetHealth((TargetHealth)((TargetHealth.Builder)TargetHealth.builder().applyMutation(targetHealth)).build());
        }

        public Builder anomalyDetection(AnomalyDetection var1);

        default public Builder anomalyDetection(Consumer<AnomalyDetection.Builder> anomalyDetection) {
            return this.anomalyDetection((AnomalyDetection)((AnomalyDetection.Builder)AnomalyDetection.builder().applyMutation(anomalyDetection)).build());
        }

        public Builder administrativeOverride(AdministrativeOverride var1);

        default public Builder administrativeOverride(Consumer<AdministrativeOverride.Builder> administrativeOverride) {
            return this.administrativeOverride((AdministrativeOverride)((AdministrativeOverride.Builder)AdministrativeOverride.builder().applyMutation(administrativeOverride)).build());
        }
    }
}

