/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a trust store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustStore implements SdkPojo, Serializable, ToCopyableBuilder<TrustStore.Builder, TrustStore> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TrustStore::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustStoreArn").getter(getter(TrustStore::trustStoreArn)).setter(setter(Builder::trustStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TrustStore::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> NUMBER_OF_CA_CERTIFICATES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfCaCertificates").getter(getter(TrustStore::numberOfCaCertificates))
            .setter(setter(Builder::numberOfCaCertificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfCaCertificates").build())
            .build();

    private static final SdkField<Long> TOTAL_REVOKED_ENTRIES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalRevokedEntries").getter(getter(TrustStore::totalRevokedEntries))
            .setter(setter(Builder::totalRevokedEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRevokedEntries").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            TRUST_STORE_ARN_FIELD, STATUS_FIELD, NUMBER_OF_CA_CERTIFICATES_FIELD, TOTAL_REVOKED_ENTRIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String trustStoreArn;

    private final String status;

    private final Integer numberOfCaCertificates;

    private final Long totalRevokedEntries;

    private TrustStore(BuilderImpl builder) {
        this.name = builder.name;
        this.trustStoreArn = builder.trustStoreArn;
        this.status = builder.status;
        this.numberOfCaCertificates = builder.numberOfCaCertificates;
        this.totalRevokedEntries = builder.totalRevokedEntries;
    }

    /**
     * <p>
     * The name of the trust store.
     * </p>
     * 
     * @return The name of the trust store.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trust store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trust store.
     */
    public final String trustStoreArn() {
        return trustStoreArn;
    }

    /**
     * <p>
     * The current status of the trust store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrustStoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the trust store.
     * @see TrustStoreStatus
     */
    public final TrustStoreStatus status() {
        return TrustStoreStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the trust store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrustStoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the trust store.
     * @see TrustStoreStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The number of ca certificates in the trust store.
     * </p>
     * 
     * @return The number of ca certificates in the trust store.
     */
    public final Integer numberOfCaCertificates() {
        return numberOfCaCertificates;
    }

    /**
     * <p>
     * The number of revoked certificates in the trust store.
     * </p>
     * 
     * @return The number of revoked certificates in the trust store.
     */
    public final Long totalRevokedEntries() {
        return totalRevokedEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfCaCertificates());
        hashCode = 31 * hashCode + Objects.hashCode(totalRevokedEntries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustStore)) {
            return false;
        }
        TrustStore other = (TrustStore) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(trustStoreArn(), other.trustStoreArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(numberOfCaCertificates(), other.numberOfCaCertificates())
                && Objects.equals(totalRevokedEntries(), other.totalRevokedEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrustStore").add("Name", name()).add("TrustStoreArn", trustStoreArn())
                .add("Status", statusAsString()).add("NumberOfCaCertificates", numberOfCaCertificates())
                .add("TotalRevokedEntries", totalRevokedEntries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TrustStoreArn":
            return Optional.ofNullable(clazz.cast(trustStoreArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "NumberOfCaCertificates":
            return Optional.ofNullable(clazz.cast(numberOfCaCertificates()));
        case "TotalRevokedEntries":
            return Optional.ofNullable(clazz.cast(totalRevokedEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrustStore, T> g) {
        return obj -> g.apply((TrustStore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustStore> {
        /**
         * <p>
         * The name of the trust store.
         * </p>
         * 
         * @param name
         *        The name of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trust store.
         * </p>
         * 
         * @param trustStoreArn
         *        The Amazon Resource Name (ARN) of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreArn(String trustStoreArn);

        /**
         * <p>
         * The current status of the trust store.
         * </p>
         * 
         * @param status
         *        The current status of the trust store.
         * @see TrustStoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustStoreStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the trust store.
         * </p>
         * 
         * @param status
         *        The current status of the trust store.
         * @see TrustStoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustStoreStatus
         */
        Builder status(TrustStoreStatus status);

        /**
         * <p>
         * The number of ca certificates in the trust store.
         * </p>
         * 
         * @param numberOfCaCertificates
         *        The number of ca certificates in the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfCaCertificates(Integer numberOfCaCertificates);

        /**
         * <p>
         * The number of revoked certificates in the trust store.
         * </p>
         * 
         * @param totalRevokedEntries
         *        The number of revoked certificates in the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRevokedEntries(Long totalRevokedEntries);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String trustStoreArn;

        private String status;

        private Integer numberOfCaCertificates;

        private Long totalRevokedEntries;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustStore model) {
            name(model.name);
            trustStoreArn(model.trustStoreArn);
            status(model.status);
            numberOfCaCertificates(model.numberOfCaCertificates);
            totalRevokedEntries(model.totalRevokedEntries);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrustStoreArn() {
            return trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrustStoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getNumberOfCaCertificates() {
            return numberOfCaCertificates;
        }

        public final void setNumberOfCaCertificates(Integer numberOfCaCertificates) {
            this.numberOfCaCertificates = numberOfCaCertificates;
        }

        @Override
        public final Builder numberOfCaCertificates(Integer numberOfCaCertificates) {
            this.numberOfCaCertificates = numberOfCaCertificates;
            return this;
        }

        public final Long getTotalRevokedEntries() {
            return totalRevokedEntries;
        }

        public final void setTotalRevokedEntries(Long totalRevokedEntries) {
            this.totalRevokedEntries = totalRevokedEntries;
        }

        @Override
        public final Builder totalRevokedEntries(Long totalRevokedEntries) {
            this.totalRevokedEntries = totalRevokedEntries;
            return this;
        }

        @Override
        public TrustStore build() {
            return new TrustStore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
