/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrustStoreRevocationsRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, DescribeTrustStoreRevocationsRequest> {
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustStoreArn").getter(DescribeTrustStoreRevocationsRequest.getter(DescribeTrustStoreRevocationsRequest::trustStoreArn)).setter(DescribeTrustStoreRevocationsRequest.setter(Builder::trustStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()}).build();
    private static final SdkField<List<Long>> REVOCATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RevocationIds").getter(DescribeTrustStoreRevocationsRequest.getter(DescribeTrustStoreRevocationsRequest::revocationIds)).setter(DescribeTrustStoreRevocationsRequest.setter(Builder::revocationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeTrustStoreRevocationsRequest.getter(DescribeTrustStoreRevocationsRequest::marker)).setter(DescribeTrustStoreRevocationsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(DescribeTrustStoreRevocationsRequest.getter(DescribeTrustStoreRevocationsRequest::pageSize)).setter(DescribeTrustStoreRevocationsRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ARN_FIELD, REVOCATION_IDS_FIELD, MARKER_FIELD, PAGE_SIZE_FIELD));
    private final String trustStoreArn;
    private final List<Long> revocationIds;
    private final String marker;
    private final Integer pageSize;

    private DescribeTrustStoreRevocationsRequest(BuilderImpl builder) {
        super(builder);
        this.trustStoreArn = builder.trustStoreArn;
        this.revocationIds = builder.revocationIds;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    public final String trustStoreArn() {
        return this.trustStoreArn;
    }

    public final boolean hasRevocationIds() {
        return this.revocationIds != null && !(this.revocationIds instanceof SdkAutoConstructList);
    }

    public final List<Long> revocationIds() {
        return this.revocationIds;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevocationIds() ? this.revocationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustStoreRevocationsRequest)) {
            return false;
        }
        DescribeTrustStoreRevocationsRequest other = (DescribeTrustStoreRevocationsRequest)((Object)obj);
        return Objects.equals(this.trustStoreArn(), other.trustStoreArn()) && this.hasRevocationIds() == other.hasRevocationIds() && Objects.equals(this.revocationIds(), other.revocationIds()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrustStoreRevocationsRequest").add("TrustStoreArn", (Object)this.trustStoreArn()).add("RevocationIds", this.hasRevocationIds() ? this.revocationIds() : null).add("Marker", (Object)this.marker()).add("PageSize", (Object)this.pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustStoreArn": {
                return Optional.ofNullable(clazz.cast(this.trustStoreArn()));
            }
            case "RevocationIds": {
                return Optional.ofNullable(clazz.cast(this.revocationIds()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustStoreRevocationsRequest, T> g) {
        return obj -> g.apply((DescribeTrustStoreRevocationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String trustStoreArn;
        private List<Long> revocationIds = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustStoreRevocationsRequest model) {
            super(model);
            this.trustStoreArn(model.trustStoreArn);
            this.revocationIds(model.revocationIds);
            this.marker(model.marker);
            this.pageSize(model.pageSize);
        }

        public final String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final Collection<Long> getRevocationIds() {
            if (this.revocationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.revocationIds;
        }

        public final void setRevocationIds(Collection<Long> revocationIds) {
            this.revocationIds = RevocationIdsCopier.copy(revocationIds);
        }

        @Override
        public final Builder revocationIds(Collection<Long> revocationIds) {
            this.revocationIds = RevocationIdsCopier.copy(revocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revocationIds(Long ... revocationIds) {
            this.revocationIds(Arrays.asList(revocationIds));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTrustStoreRevocationsRequest build() {
            return new DescribeTrustStoreRevocationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrustStoreRevocationsRequest> {
        public Builder trustStoreArn(String var1);

        public Builder revocationIds(Collection<Long> var1);

        public Builder revocationIds(Long ... var1);

        public Builder marker(String var1);

        public Builder pageSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

