/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticloadbalancingv2.DefaultElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.DefaultElasticLoadBalancingV2BaseClientBuilder;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClientBuilder;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2ServiceClientConfiguration;
import software.amazon.awssdk.services.elasticloadbalancingv2.endpoints.ElasticLoadBalancingV2EndpointProvider;

@SdkInternalApi
final class DefaultElasticLoadBalancingV2AsyncClientBuilder
extends DefaultElasticLoadBalancingV2BaseClientBuilder<ElasticLoadBalancingV2AsyncClientBuilder, ElasticLoadBalancingV2AsyncClient>
implements ElasticLoadBalancingV2AsyncClientBuilder {
    DefaultElasticLoadBalancingV2AsyncClientBuilder() {
    }

    @Override
    public DefaultElasticLoadBalancingV2AsyncClientBuilder endpointProvider(ElasticLoadBalancingV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElasticLoadBalancingV2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultElasticLoadBalancingV2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        ElasticLoadBalancingV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultElasticLoadBalancingV2AsyncClient client = new DefaultElasticLoadBalancingV2AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ElasticLoadBalancingV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ElasticLoadBalancingV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

