/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionTypeEnum {
    FORWARD("forward"),
    AUTHENTICATE_OIDC("authenticate-oidc"),
    AUTHENTICATE_COGNITO("authenticate-cognito"),
    REDIRECT("redirect"),
    FIXED_RESPONSE("fixed-response"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionTypeEnum> VALUE_MAP;
    private final String value;

    private ActionTypeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionTypeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionTypeEnum> knownValues() {
        EnumSet<ActionTypeEnum> knownValues = EnumSet.allOf(ActionTypeEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionTypeEnum.class, ActionTypeEnum::toString);
    }
}

