/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTargetHealthRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, DescribeTargetHealthRequest> {
    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetGroupArn").getter(DescribeTargetHealthRequest.getter(DescribeTargetHealthRequest::targetGroupArn)).setter(DescribeTargetHealthRequest.setter(Builder::targetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupArn").build()}).build();
    private static final SdkField<List<TargetDescription>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(DescribeTargetHealthRequest.getter(DescribeTargetHealthRequest::targets)).setter(DescribeTargetHealthRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUP_ARN_FIELD, TARGETS_FIELD));
    private final String targetGroupArn;
    private final List<TargetDescription> targets;

    private DescribeTargetHealthRequest(BuilderImpl builder) {
        super(builder);
        this.targetGroupArn = builder.targetGroupArn;
        this.targets = builder.targets;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public List<TargetDescription> targets() {
        return this.targets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetHealthRequest)) {
            return false;
        }
        DescribeTargetHealthRequest other = (DescribeTargetHealthRequest)((Object)obj);
        return Objects.equals(this.targetGroupArn(), other.targetGroupArn()) && Objects.equals(this.targets(), other.targets());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTargetHealthRequest").add("TargetGroupArn", (Object)this.targetGroupArn()).add("Targets", this.targets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.targetGroupArn()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTargetHealthRequest, T> g) {
        return obj -> g.apply((DescribeTargetHealthRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String targetGroupArn;
        private List<TargetDescription> targets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTargetHealthRequest model) {
            super(model);
            this.targetGroupArn(model.targetGroupArn);
            this.targets(model.targets);
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final Collection<TargetDescription.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(TargetDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<TargetDescription> targets) {
            this.targets = TargetDescriptionsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(TargetDescription ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<TargetDescription.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (TargetDescription)((TargetDescription.Builder)TargetDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<TargetDescription.BuilderImpl> targets) {
            this.targets = TargetDescriptionsCopier.copyFromBuilder(targets);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTargetHealthRequest build() {
            return new DescribeTargetHealthRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTargetHealthRequest> {
        public Builder targetGroupArn(String var1);

        public Builder targets(Collection<TargetDescription> var1);

        public Builder targets(TargetDescription ... var1);

        public Builder targets(Consumer<TargetDescription.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

