/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagListCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTargetGroupRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, CreateTargetGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::name)).setter(CreateTargetGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::protocolAsString)).setter(CreateTargetGroupRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::port)).setter(CreateTargetGroupRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::vpcId)).setter(CreateTargetGroupRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckProtocol").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::healthCheckProtocolAsString)).setter(CreateTargetGroupRequest.setter(Builder::healthCheckProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckProtocol").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckPort").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::healthCheckPort)).setter(CreateTargetGroupRequest.setter(Builder::healthCheckPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPort").build()}).build();
    private static final SdkField<Boolean> HEALTH_CHECK_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HealthCheckEnabled").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::healthCheckEnabled)).setter(CreateTargetGroupRequest.setter(Builder::healthCheckEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckEnabled").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckPath").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::healthCheckPath)).setter(CreateTargetGroupRequest.setter(Builder::healthCheckPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPath").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthCheckIntervalSeconds").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::healthCheckIntervalSeconds)).setter(CreateTargetGroupRequest.setter(Builder::healthCheckIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckIntervalSeconds").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthCheckTimeoutSeconds").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::healthCheckTimeoutSeconds)).setter(CreateTargetGroupRequest.setter(Builder::healthCheckTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckTimeoutSeconds").build()}).build();
    private static final SdkField<Integer> HEALTHY_THRESHOLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthyThresholdCount").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::healthyThresholdCount)).setter(CreateTargetGroupRequest.setter(Builder::healthyThresholdCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthyThresholdCount").build()}).build();
    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UnhealthyThresholdCount").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::unhealthyThresholdCount)).setter(CreateTargetGroupRequest.setter(Builder::unhealthyThresholdCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyThresholdCount").build()}).build();
    private static final SdkField<Matcher> MATCHER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Matcher").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::matcher)).setter(CreateTargetGroupRequest.setter(Builder::matcher)).constructor(Matcher::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matcher").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::targetTypeAsString)).setter(CreateTargetGroupRequest.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateTargetGroupRequest.getter(CreateTargetGroupRequest::tags)).setter(CreateTargetGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PROTOCOL_FIELD, PORT_FIELD, VPC_ID_FIELD, HEALTH_CHECK_PROTOCOL_FIELD, HEALTH_CHECK_PORT_FIELD, HEALTH_CHECK_ENABLED_FIELD, HEALTH_CHECK_PATH_FIELD, HEALTH_CHECK_INTERVAL_SECONDS_FIELD, HEALTH_CHECK_TIMEOUT_SECONDS_FIELD, HEALTHY_THRESHOLD_COUNT_FIELD, UNHEALTHY_THRESHOLD_COUNT_FIELD, MATCHER_FIELD, TARGET_TYPE_FIELD, TAGS_FIELD));
    private final String name;
    private final String protocol;
    private final Integer port;
    private final String vpcId;
    private final String healthCheckProtocol;
    private final String healthCheckPort;
    private final Boolean healthCheckEnabled;
    private final String healthCheckPath;
    private final Integer healthCheckIntervalSeconds;
    private final Integer healthCheckTimeoutSeconds;
    private final Integer healthyThresholdCount;
    private final Integer unhealthyThresholdCount;
    private final Matcher matcher;
    private final String targetType;
    private final List<Tag> tags;

    private CreateTargetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.vpcId = builder.vpcId;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckEnabled = builder.healthCheckEnabled;
        this.healthCheckPath = builder.healthCheckPath;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
        this.healthyThresholdCount = builder.healthyThresholdCount;
        this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
        this.matcher = builder.matcher;
        this.targetType = builder.targetType;
        this.tags = builder.tags;
    }

    public String name() {
        return this.name;
    }

    public ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public Integer port() {
        return this.port;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public ProtocolEnum healthCheckProtocol() {
        return ProtocolEnum.fromValue(this.healthCheckProtocol);
    }

    public String healthCheckProtocolAsString() {
        return this.healthCheckProtocol;
    }

    public String healthCheckPort() {
        return this.healthCheckPort;
    }

    public Boolean healthCheckEnabled() {
        return this.healthCheckEnabled;
    }

    public String healthCheckPath() {
        return this.healthCheckPath;
    }

    public Integer healthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds;
    }

    public Integer healthCheckTimeoutSeconds() {
        return this.healthCheckTimeoutSeconds;
    }

    public Integer healthyThresholdCount() {
        return this.healthyThresholdCount;
    }

    public Integer unhealthyThresholdCount() {
        return this.unhealthyThresholdCount;
    }

    public Matcher matcher() {
        return this.matcher;
    }

    public TargetTypeEnum targetType() {
        return TargetTypeEnum.fromValue(this.targetType);
    }

    public String targetTypeAsString() {
        return this.targetType;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.matcher());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTargetGroupRequest)) {
            return false;
        }
        CreateTargetGroupRequest other = (CreateTargetGroupRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.healthCheckProtocolAsString(), other.healthCheckProtocolAsString()) && Objects.equals(this.healthCheckPort(), other.healthCheckPort()) && Objects.equals(this.healthCheckEnabled(), other.healthCheckEnabled()) && Objects.equals(this.healthCheckPath(), other.healthCheckPath()) && Objects.equals(this.healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds()) && Objects.equals(this.healthCheckTimeoutSeconds(), other.healthCheckTimeoutSeconds()) && Objects.equals(this.healthyThresholdCount(), other.healthyThresholdCount()) && Objects.equals(this.unhealthyThresholdCount(), other.unhealthyThresholdCount()) && Objects.equals(this.matcher(), other.matcher()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateTargetGroupRequest").add("Name", (Object)this.name()).add("Protocol", (Object)this.protocolAsString()).add("Port", (Object)this.port()).add("VpcId", (Object)this.vpcId()).add("HealthCheckProtocol", (Object)this.healthCheckProtocolAsString()).add("HealthCheckPort", (Object)this.healthCheckPort()).add("HealthCheckEnabled", (Object)this.healthCheckEnabled()).add("HealthCheckPath", (Object)this.healthCheckPath()).add("HealthCheckIntervalSeconds", (Object)this.healthCheckIntervalSeconds()).add("HealthCheckTimeoutSeconds", (Object)this.healthCheckTimeoutSeconds()).add("HealthyThresholdCount", (Object)this.healthyThresholdCount()).add("UnhealthyThresholdCount", (Object)this.unhealthyThresholdCount()).add("Matcher", (Object)this.matcher()).add("TargetType", (Object)this.targetTypeAsString()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "HealthCheckProtocol": {
                return Optional.ofNullable(clazz.cast(this.healthCheckProtocolAsString()));
            }
            case "HealthCheckPort": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPort()));
            }
            case "HealthCheckEnabled": {
                return Optional.ofNullable(clazz.cast(this.healthCheckEnabled()));
            }
            case "HealthCheckPath": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPath()));
            }
            case "HealthCheckIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckIntervalSeconds()));
            }
            case "HealthCheckTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckTimeoutSeconds()));
            }
            case "HealthyThresholdCount": {
                return Optional.ofNullable(clazz.cast(this.healthyThresholdCount()));
            }
            case "UnhealthyThresholdCount": {
                return Optional.ofNullable(clazz.cast(this.unhealthyThresholdCount()));
            }
            case "Matcher": {
                return Optional.ofNullable(clazz.cast(this.matcher()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTargetGroupRequest, T> g) {
        return obj -> g.apply((CreateTargetGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String name;
        private String protocol;
        private Integer port;
        private String vpcId;
        private String healthCheckProtocol;
        private String healthCheckPort;
        private Boolean healthCheckEnabled;
        private String healthCheckPath;
        private Integer healthCheckIntervalSeconds;
        private Integer healthCheckTimeoutSeconds;
        private Integer healthyThresholdCount;
        private Integer unhealthyThresholdCount;
        private Matcher matcher;
        private String targetType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTargetGroupRequest model) {
            super(model);
            this.name(model.name);
            this.protocol(model.protocol);
            this.port(model.port);
            this.vpcId(model.vpcId);
            this.healthCheckProtocol(model.healthCheckProtocol);
            this.healthCheckPort(model.healthCheckPort);
            this.healthCheckEnabled(model.healthCheckEnabled);
            this.healthCheckPath(model.healthCheckPath);
            this.healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            this.healthCheckTimeoutSeconds(model.healthCheckTimeoutSeconds);
            this.healthyThresholdCount(model.healthyThresholdCount);
            this.unhealthyThresholdCount(model.unhealthyThresholdCount);
            this.matcher(model.matcher);
            this.targetType(model.targetType);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getHealthCheckProtocol() {
            return this.healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol == null ? null : healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final Boolean getHealthCheckEnabled() {
            return this.healthCheckEnabled;
        }

        @Override
        public final Builder healthCheckEnabled(Boolean healthCheckEnabled) {
            this.healthCheckEnabled = healthCheckEnabled;
            return this;
        }

        public final void setHealthCheckEnabled(Boolean healthCheckEnabled) {
            this.healthCheckEnabled = healthCheckEnabled;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return this.healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getHealthCheckTimeoutSeconds() {
            return this.healthCheckTimeoutSeconds;
        }

        @Override
        public final Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public final void setHealthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
        }

        public final Integer getHealthyThresholdCount() {
            return this.healthyThresholdCount;
        }

        @Override
        public final Builder healthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public final void setHealthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
        }

        public final Integer getUnhealthyThresholdCount() {
            return this.unhealthyThresholdCount;
        }

        @Override
        public final Builder unhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public final void setUnhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        public final Matcher.Builder getMatcher() {
            return this.matcher != null ? this.matcher.toBuilder() : null;
        }

        @Override
        public final Builder matcher(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public final void setMatcher(Matcher.BuilderImpl matcher) {
            this.matcher = matcher != null ? matcher.build() : null;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetTypeEnum targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTargetGroupRequest build() {
            return new CreateTargetGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTargetGroupRequest> {
        public Builder name(String var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolEnum var1);

        public Builder port(Integer var1);

        public Builder vpcId(String var1);

        public Builder healthCheckProtocol(String var1);

        public Builder healthCheckProtocol(ProtocolEnum var1);

        public Builder healthCheckPort(String var1);

        public Builder healthCheckEnabled(Boolean var1);

        public Builder healthCheckPath(String var1);

        public Builder healthCheckIntervalSeconds(Integer var1);

        public Builder healthCheckTimeoutSeconds(Integer var1);

        public Builder healthyThresholdCount(Integer var1);

        public Builder unhealthyThresholdCount(Integer var1);

        public Builder matcher(Matcher var1);

        default public Builder matcher(Consumer<Matcher.Builder> matcher) {
            return this.matcher((Matcher)((Matcher.Builder)Matcher.builder().applyMutation(matcher)).build());
        }

        public Builder targetType(String var1);

        public Builder targetType(TargetTypeEnum var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

