/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.FixedResponseActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Action
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Action> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Action.getter(Action::typeAsString)).setter(Action.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Action.getter(Action::targetGroupArn)).setter(Action.setter(Builder::targetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupArn").build()}).build();
    private static final SdkField<AuthenticateOidcActionConfig> AUTHENTICATE_OIDC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::authenticateOidcConfig)).setter(Action.setter(Builder::authenticateOidcConfig)).constructor(AuthenticateOidcActionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticateOidcConfig").build()}).build();
    private static final SdkField<AuthenticateCognitoActionConfig> AUTHENTICATE_COGNITO_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::authenticateCognitoConfig)).setter(Action.setter(Builder::authenticateCognitoConfig)).constructor(AuthenticateCognitoActionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticateCognitoConfig").build()}).build();
    private static final SdkField<Integer> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Action.getter(Action::order)).setter(Action.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Order").build()}).build();
    private static final SdkField<RedirectActionConfig> REDIRECT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::redirectConfig)).setter(Action.setter(Builder::redirectConfig)).constructor(RedirectActionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectConfig").build()}).build();
    private static final SdkField<FixedResponseActionConfig> FIXED_RESPONSE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::fixedResponseConfig)).setter(Action.setter(Builder::fixedResponseConfig)).constructor(FixedResponseActionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedResponseConfig").build()}).build();
    private static final SdkField<ForwardActionConfig> FORWARD_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::forwardConfig)).setter(Action.setter(Builder::forwardConfig)).constructor(ForwardActionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TARGET_GROUP_ARN_FIELD, AUTHENTICATE_OIDC_CONFIG_FIELD, AUTHENTICATE_COGNITO_CONFIG_FIELD, ORDER_FIELD, REDIRECT_CONFIG_FIELD, FIXED_RESPONSE_CONFIG_FIELD, FORWARD_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String targetGroupArn;
    private final AuthenticateOidcActionConfig authenticateOidcConfig;
    private final AuthenticateCognitoActionConfig authenticateCognitoConfig;
    private final Integer order;
    private final RedirectActionConfig redirectConfig;
    private final FixedResponseActionConfig fixedResponseConfig;
    private final ForwardActionConfig forwardConfig;

    private Action(BuilderImpl builder) {
        this.type = builder.type;
        this.targetGroupArn = builder.targetGroupArn;
        this.authenticateOidcConfig = builder.authenticateOidcConfig;
        this.authenticateCognitoConfig = builder.authenticateCognitoConfig;
        this.order = builder.order;
        this.redirectConfig = builder.redirectConfig;
        this.fixedResponseConfig = builder.fixedResponseConfig;
        this.forwardConfig = builder.forwardConfig;
    }

    public ActionTypeEnum type() {
        return ActionTypeEnum.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public AuthenticateOidcActionConfig authenticateOidcConfig() {
        return this.authenticateOidcConfig;
    }

    public AuthenticateCognitoActionConfig authenticateCognitoConfig() {
        return this.authenticateCognitoConfig;
    }

    public Integer order() {
        return this.order;
    }

    public RedirectActionConfig redirectConfig() {
        return this.redirectConfig;
    }

    public FixedResponseActionConfig fixedResponseConfig() {
        return this.fixedResponseConfig;
    }

    public ForwardActionConfig forwardConfig() {
        return this.forwardConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticateOidcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticateCognitoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.order());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedResponseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.targetGroupArn(), other.targetGroupArn()) && Objects.equals(this.authenticateOidcConfig(), other.authenticateOidcConfig()) && Objects.equals(this.authenticateCognitoConfig(), other.authenticateCognitoConfig()) && Objects.equals(this.order(), other.order()) && Objects.equals(this.redirectConfig(), other.redirectConfig()) && Objects.equals(this.fixedResponseConfig(), other.fixedResponseConfig()) && Objects.equals(this.forwardConfig(), other.forwardConfig());
    }

    public String toString() {
        return ToString.builder((String)"Action").add("Type", (Object)this.typeAsString()).add("TargetGroupArn", (Object)this.targetGroupArn()).add("AuthenticateOidcConfig", (Object)this.authenticateOidcConfig()).add("AuthenticateCognitoConfig", (Object)this.authenticateCognitoConfig()).add("Order", (Object)this.order()).add("RedirectConfig", (Object)this.redirectConfig()).add("FixedResponseConfig", (Object)this.fixedResponseConfig()).add("ForwardConfig", (Object)this.forwardConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TargetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.targetGroupArn()));
            }
            case "AuthenticateOidcConfig": {
                return Optional.ofNullable(clazz.cast(this.authenticateOidcConfig()));
            }
            case "AuthenticateCognitoConfig": {
                return Optional.ofNullable(clazz.cast(this.authenticateCognitoConfig()));
            }
            case "Order": {
                return Optional.ofNullable(clazz.cast(this.order()));
            }
            case "RedirectConfig": {
                return Optional.ofNullable(clazz.cast(this.redirectConfig()));
            }
            case "FixedResponseConfig": {
                return Optional.ofNullable(clazz.cast(this.fixedResponseConfig()));
            }
            case "ForwardConfig": {
                return Optional.ofNullable(clazz.cast(this.forwardConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String targetGroupArn;
        private AuthenticateOidcActionConfig authenticateOidcConfig;
        private AuthenticateCognitoActionConfig authenticateCognitoConfig;
        private Integer order;
        private RedirectActionConfig redirectConfig;
        private FixedResponseActionConfig fixedResponseConfig;
        private ForwardActionConfig forwardConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.type(model.type);
            this.targetGroupArn(model.targetGroupArn);
            this.authenticateOidcConfig(model.authenticateOidcConfig);
            this.authenticateCognitoConfig(model.authenticateCognitoConfig);
            this.order(model.order);
            this.redirectConfig(model.redirectConfig);
            this.fixedResponseConfig(model.fixedResponseConfig);
            this.forwardConfig(model.forwardConfig);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionTypeEnum type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final AuthenticateOidcActionConfig.Builder getAuthenticateOidcConfig() {
            return this.authenticateOidcConfig != null ? this.authenticateOidcConfig.toBuilder() : null;
        }

        @Override
        public final Builder authenticateOidcConfig(AuthenticateOidcActionConfig authenticateOidcConfig) {
            this.authenticateOidcConfig = authenticateOidcConfig;
            return this;
        }

        public final void setAuthenticateOidcConfig(AuthenticateOidcActionConfig.BuilderImpl authenticateOidcConfig) {
            this.authenticateOidcConfig = authenticateOidcConfig != null ? authenticateOidcConfig.build() : null;
        }

        public final AuthenticateCognitoActionConfig.Builder getAuthenticateCognitoConfig() {
            return this.authenticateCognitoConfig != null ? this.authenticateCognitoConfig.toBuilder() : null;
        }

        @Override
        public final Builder authenticateCognitoConfig(AuthenticateCognitoActionConfig authenticateCognitoConfig) {
            this.authenticateCognitoConfig = authenticateCognitoConfig;
            return this;
        }

        public final void setAuthenticateCognitoConfig(AuthenticateCognitoActionConfig.BuilderImpl authenticateCognitoConfig) {
            this.authenticateCognitoConfig = authenticateCognitoConfig != null ? authenticateCognitoConfig.build() : null;
        }

        public final Integer getOrder() {
            return this.order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        public final RedirectActionConfig.Builder getRedirectConfig() {
            return this.redirectConfig != null ? this.redirectConfig.toBuilder() : null;
        }

        @Override
        public final Builder redirectConfig(RedirectActionConfig redirectConfig) {
            this.redirectConfig = redirectConfig;
            return this;
        }

        public final void setRedirectConfig(RedirectActionConfig.BuilderImpl redirectConfig) {
            this.redirectConfig = redirectConfig != null ? redirectConfig.build() : null;
        }

        public final FixedResponseActionConfig.Builder getFixedResponseConfig() {
            return this.fixedResponseConfig != null ? this.fixedResponseConfig.toBuilder() : null;
        }

        @Override
        public final Builder fixedResponseConfig(FixedResponseActionConfig fixedResponseConfig) {
            this.fixedResponseConfig = fixedResponseConfig;
            return this;
        }

        public final void setFixedResponseConfig(FixedResponseActionConfig.BuilderImpl fixedResponseConfig) {
            this.fixedResponseConfig = fixedResponseConfig != null ? fixedResponseConfig.build() : null;
        }

        public final ForwardActionConfig.Builder getForwardConfig() {
            return this.forwardConfig != null ? this.forwardConfig.toBuilder() : null;
        }

        @Override
        public final Builder forwardConfig(ForwardActionConfig forwardConfig) {
            this.forwardConfig = forwardConfig;
            return this;
        }

        public final void setForwardConfig(ForwardActionConfig.BuilderImpl forwardConfig) {
            this.forwardConfig = forwardConfig != null ? forwardConfig.build() : null;
        }

        public Action build() {
            return new Action(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Action> {
        public Builder type(String var1);

        public Builder type(ActionTypeEnum var1);

        public Builder targetGroupArn(String var1);

        public Builder authenticateOidcConfig(AuthenticateOidcActionConfig var1);

        default public Builder authenticateOidcConfig(Consumer<AuthenticateOidcActionConfig.Builder> authenticateOidcConfig) {
            return this.authenticateOidcConfig((AuthenticateOidcActionConfig)((AuthenticateOidcActionConfig.Builder)AuthenticateOidcActionConfig.builder().applyMutation(authenticateOidcConfig)).build());
        }

        public Builder authenticateCognitoConfig(AuthenticateCognitoActionConfig var1);

        default public Builder authenticateCognitoConfig(Consumer<AuthenticateCognitoActionConfig.Builder> authenticateCognitoConfig) {
            return this.authenticateCognitoConfig((AuthenticateCognitoActionConfig)((AuthenticateCognitoActionConfig.Builder)AuthenticateCognitoActionConfig.builder().applyMutation(authenticateCognitoConfig)).build());
        }

        public Builder order(Integer var1);

        public Builder redirectConfig(RedirectActionConfig var1);

        default public Builder redirectConfig(Consumer<RedirectActionConfig.Builder> redirectConfig) {
            return this.redirectConfig((RedirectActionConfig)((RedirectActionConfig.Builder)RedirectActionConfig.builder().applyMutation(redirectConfig)).build());
        }

        public Builder fixedResponseConfig(FixedResponseActionConfig var1);

        default public Builder fixedResponseConfig(Consumer<FixedResponseActionConfig.Builder> fixedResponseConfig) {
            return this.fixedResponseConfig((FixedResponseActionConfig)((FixedResponseActionConfig.Builder)FixedResponseActionConfig.builder().applyMutation(fixedResponseConfig)).build());
        }

        public Builder forwardConfig(ForwardActionConfig var1);

        default public Builder forwardConfig(Consumer<ForwardActionConfig.Builder> forwardConfig) {
            return this.forwardConfig((ForwardActionConfig)((ForwardActionConfig.Builder)ForwardActionConfig.builder().applyMutation(forwardConfig)).build());
        }
    }
}

