/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetGroupTuple
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetGroupTuple> {
    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TargetGroupTuple.getter(TargetGroupTuple::targetGroupArn)).setter(TargetGroupTuple.setter(Builder::targetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupArn").build()}).build();
    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TargetGroupTuple.getter(TargetGroupTuple::weight)).setter(TargetGroupTuple.setter(Builder::weight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUP_ARN_FIELD, WEIGHT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetGroupArn;
    private final Integer weight;

    private TargetGroupTuple(BuilderImpl builder) {
        this.targetGroupArn = builder.targetGroupArn;
        this.weight = builder.weight;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public Integer weight() {
        return this.weight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroupTuple)) {
            return false;
        }
        TargetGroupTuple other = (TargetGroupTuple)obj;
        return Objects.equals(this.targetGroupArn(), other.targetGroupArn()) && Objects.equals(this.weight(), other.weight());
    }

    public String toString() {
        return ToString.builder((String)"TargetGroupTuple").add("TargetGroupArn", (Object)this.targetGroupArn()).add("Weight", (Object)this.weight()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.targetGroupArn()));
            }
            case "Weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetGroupTuple, T> g) {
        return obj -> g.apply((TargetGroupTuple)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetGroupArn;
        private Integer weight;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroupTuple model) {
            this.targetGroupArn(model.targetGroupArn);
            this.weight(model.weight);
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final Integer getWeight() {
            return this.weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        public TargetGroupTuple build() {
            return new TargetGroupTuple(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetGroupTuple> {
        public Builder targetGroupArn(String var1);

        public Builder weight(Integer var1);
    }
}

