/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubnetMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubnetMapping> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubnetMapping.getter(SubnetMapping::subnetId)).setter(SubnetMapping.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubnetMapping.getter(SubnetMapping::allocationId)).setter(SubnetMapping.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").build()}).build();
    private static final SdkField<Boolean> STATIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SubnetMapping.getter(SubnetMapping::staticIp)).setter(SubnetMapping.setter(Builder::staticIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, ALLOCATION_ID_FIELD, STATIC_IP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String subnetId;
    private final String allocationId;
    private final Boolean staticIp;

    private SubnetMapping(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.allocationId = builder.allocationId;
        this.staticIp = builder.staticIp;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public Boolean staticIp() {
        return this.staticIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticIp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetMapping)) {
            return false;
        }
        SubnetMapping other = (SubnetMapping)obj;
        return Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.staticIp(), other.staticIp());
    }

    public String toString() {
        return ToString.builder((String)"SubnetMapping").add("SubnetId", (Object)this.subnetId()).add("AllocationId", (Object)this.allocationId()).add("StaticIp", (Object)this.staticIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "StaticIp": {
                return Optional.ofNullable(clazz.cast(this.staticIp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubnetMapping, T> g) {
        return obj -> g.apply((SubnetMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetId;
        private String allocationId;
        private Boolean staticIp;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetMapping model) {
            this.subnetId(model.subnetId);
            this.allocationId(model.allocationId);
            this.staticIp(model.staticIp);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final Boolean getStaticIp() {
            return this.staticIp;
        }

        @Override
        public final Builder staticIp(Boolean staticIp) {
            this.staticIp = staticIp;
            return this;
        }

        public final void setStaticIp(Boolean staticIp) {
            this.staticIp = staticIp;
        }

        public SubnetMapping build() {
            return new SubnetMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubnetMapping> {
        public Builder subnetId(String var1);

        public Builder allocationId(String var1);

        public Builder staticIp(Boolean var1);
    }
}

