/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProvisionedCapacityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedCapacity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisionedCapacity> {
    private static final SdkField<Integer> MINIMUM_LB_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ProvisionedCapacity.getter(ProvisionedCapacity::minimumLBCapacityUnits)).setter(ProvisionedCapacity.setter(Builder::minimumLBCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumLBCapacityUnits").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvisionedCapacity.getter(ProvisionedCapacity::statusAsString)).setter(ProvisionedCapacity.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> DECREASES_REMAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ProvisionedCapacity.getter(ProvisionedCapacity::decreasesRemaining)).setter(ProvisionedCapacity.setter(Builder::decreasesRemaining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecreasesRemaining").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProvisionedCapacity.getter(ProvisionedCapacity::lastModifiedTime)).setter(ProvisionedCapacity.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_LB_CAPACITY_UNITS_FIELD, STATUS_FIELD, DECREASES_REMAINING_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer minimumLBCapacityUnits;
    private final String status;
    private final Integer decreasesRemaining;
    private final Instant lastModifiedTime;

    private ProvisionedCapacity(BuilderImpl builder) {
        this.minimumLBCapacityUnits = builder.minimumLBCapacityUnits;
        this.status = builder.status;
        this.decreasesRemaining = builder.decreasesRemaining;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public Integer minimumLBCapacityUnits() {
        return this.minimumLBCapacityUnits;
    }

    public ProvisionedCapacityStatus status() {
        return ProvisionedCapacityStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Integer decreasesRemaining() {
        return this.decreasesRemaining;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLBCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.decreasesRemaining());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedCapacity)) {
            return false;
        }
        ProvisionedCapacity other = (ProvisionedCapacity)obj;
        return Objects.equals(this.minimumLBCapacityUnits(), other.minimumLBCapacityUnits()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.decreasesRemaining(), other.decreasesRemaining()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public String toString() {
        return ToString.builder((String)"ProvisionedCapacity").add("MinimumLBCapacityUnits", (Object)this.minimumLBCapacityUnits()).add("Status", (Object)this.statusAsString()).add("DecreasesRemaining", (Object)this.decreasesRemaining()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumLBCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.minimumLBCapacityUnits()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DecreasesRemaining": {
                return Optional.ofNullable(clazz.cast(this.decreasesRemaining()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedCapacity, T> g) {
        return obj -> g.apply((ProvisionedCapacity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minimumLBCapacityUnits;
        private String status;
        private Integer decreasesRemaining;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedCapacity model) {
            this.minimumLBCapacityUnits(model.minimumLBCapacityUnits);
            this.status(model.status);
            this.decreasesRemaining(model.decreasesRemaining);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final Integer getMinimumLBCapacityUnits() {
            return this.minimumLBCapacityUnits;
        }

        @Override
        public final Builder minimumLBCapacityUnits(Integer minimumLBCapacityUnits) {
            this.minimumLBCapacityUnits = minimumLBCapacityUnits;
            return this;
        }

        public final void setMinimumLBCapacityUnits(Integer minimumLBCapacityUnits) {
            this.minimumLBCapacityUnits = minimumLBCapacityUnits;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProvisionedCapacityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getDecreasesRemaining() {
            return this.decreasesRemaining;
        }

        @Override
        public final Builder decreasesRemaining(Integer decreasesRemaining) {
            this.decreasesRemaining = decreasesRemaining;
            return this;
        }

        public final void setDecreasesRemaining(Integer decreasesRemaining) {
            this.decreasesRemaining = decreasesRemaining;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public ProvisionedCapacity build() {
            return new ProvisionedCapacity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionedCapacity> {
        public Builder minimumLBCapacityUnits(Integer var1);

        public Builder status(String var1);

        public Builder status(ProvisionedCapacityStatus var1);

        public Builder decreasesRemaining(Integer var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

