/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyProvisionedCapacityRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, ModifyProvisionedCapacityRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyProvisionedCapacityRequest.getter(ModifyProvisionedCapacityRequest::loadBalancerArn)).setter(ModifyProvisionedCapacityRequest.setter(Builder::loadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()}).build();
    private static final SdkField<Integer> MINIMUM_LB_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ModifyProvisionedCapacityRequest.getter(ModifyProvisionedCapacityRequest::minimumLBCapacityUnits)).setter(ModifyProvisionedCapacityRequest.setter(Builder::minimumLBCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumLBCapacityUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD, MINIMUM_LB_CAPACITY_UNITS_FIELD));
    private final String loadBalancerArn;
    private final Integer minimumLBCapacityUnits;

    private ModifyProvisionedCapacityRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.minimumLBCapacityUnits = builder.minimumLBCapacityUnits;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public Integer minimumLBCapacityUnits() {
        return this.minimumLBCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLBCapacityUnits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyProvisionedCapacityRequest)) {
            return false;
        }
        ModifyProvisionedCapacityRequest other = (ModifyProvisionedCapacityRequest)((Object)obj);
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.minimumLBCapacityUnits(), other.minimumLBCapacityUnits());
    }

    public String toString() {
        return ToString.builder((String)"ModifyProvisionedCapacityRequest").add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("MinimumLBCapacityUnits", (Object)this.minimumLBCapacityUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "MinimumLBCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.minimumLBCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyProvisionedCapacityRequest, T> g) {
        return obj -> g.apply((ModifyProvisionedCapacityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private Integer minimumLBCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyProvisionedCapacityRequest model) {
            super(model);
            this.loadBalancerArn(model.loadBalancerArn);
            this.minimumLBCapacityUnits(model.minimumLBCapacityUnits);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final Integer getMinimumLBCapacityUnits() {
            return this.minimumLBCapacityUnits;
        }

        @Override
        public final Builder minimumLBCapacityUnits(Integer minimumLBCapacityUnits) {
            this.minimumLBCapacityUnits = minimumLBCapacityUnits;
            return this;
        }

        public final void setMinimumLBCapacityUnits(Integer minimumLBCapacityUnits) {
            this.minimumLBCapacityUnits = minimumLBCapacityUnits;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyProvisionedCapacityRequest build() {
            return new ModifyProvisionedCapacityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyProvisionedCapacityRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder minimumLBCapacityUnits(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

