/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest;

public class RemoveTagsRequestMarshaller
implements Marshaller<Request<RemoveTagsRequest>, RemoveTagsRequest> {
    public Request<RemoveTagsRequest> marshall(RemoveTagsRequest removeTagsRequest) {
        List<String> tagKeysList;
        if (removeTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)removeTagsRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "RemoveTags");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> resourceArnsList = removeTagsRequest.resourceArns();
        if (resourceArnsList != null) {
            if (!resourceArnsList.isEmpty()) {
                int resourceArnsListIndex = 1;
                for (String resourceArnsListValue : resourceArnsList) {
                    if (resourceArnsListValue != null) {
                        request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringUtils.fromString((String)resourceArnsListValue));
                    }
                    ++resourceArnsListIndex;
                }
            } else {
                request.addParameter("ResourceArns", "");
            }
        }
        if ((tagKeysList = removeTagsRequest.tagKeys()) != null) {
            if (!tagKeysList.isEmpty()) {
                int tagKeysListIndex = 1;
                for (String tagKeysListValue : tagKeysList) {
                    if (tagKeysListValue != null) {
                        request.addParameter("TagKeys.member." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                    }
                    ++tagKeysListIndex;
                }
            } else {
                request.addParameter("TagKeys", "");
            }
        }
        return request;
    }
}

