/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;

public class DescribeLoadBalancersRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancersRequest>, DescribeLoadBalancersRequest> {
    public Request<DescribeLoadBalancersRequest> marshall(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        List<String> namesList;
        if (describeLoadBalancersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeLoadBalancersRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "DescribeLoadBalancers");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> loadBalancerArnsList = describeLoadBalancersRequest.loadBalancerArns();
        if (loadBalancerArnsList != null) {
            if (!loadBalancerArnsList.isEmpty()) {
                int loadBalancerArnsListIndex = 1;
                for (String loadBalancerArnsListValue : loadBalancerArnsList) {
                    if (loadBalancerArnsListValue != null) {
                        request.addParameter("LoadBalancerArns.member." + loadBalancerArnsListIndex, StringUtils.fromString((String)loadBalancerArnsListValue));
                    }
                    ++loadBalancerArnsListIndex;
                }
            } else {
                request.addParameter("LoadBalancerArns", "");
            }
        }
        if ((namesList = describeLoadBalancersRequest.names()) != null) {
            if (!namesList.isEmpty()) {
                int namesListIndex = 1;
                for (String namesListValue : namesList) {
                    if (namesListValue != null) {
                        request.addParameter("Names.member." + namesListIndex, StringUtils.fromString((String)namesListValue));
                    }
                    ++namesListIndex;
                }
            } else {
                request.addParameter("Names", "");
            }
        }
        if (describeLoadBalancersRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeLoadBalancersRequest.marker()));
        }
        if (describeLoadBalancersRequest.pageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeLoadBalancersRequest.pageSize()));
        }
        return request;
    }
}

