/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingv2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;

public class DescribeLoadBalancersPublisher
implements SdkPublisher<DescribeLoadBalancersResponse> {
    private final ElasticLoadBalancingv2AsyncClient client;
    private final DescribeLoadBalancersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLoadBalancersPublisher(ElasticLoadBalancingv2AsyncClient client, DescribeLoadBalancersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLoadBalancersPublisher(ElasticLoadBalancingv2AsyncClient client, DescribeLoadBalancersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLoadBalancersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLoadBalancersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<LoadBalancer> loadBalancers() {
        Function<DescribeLoadBalancersResponse, Iterator> getIterator = response -> {
            if (response != null && response.loadBalancers() != null) {
                return response.loadBalancers().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeLoadBalancersResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeLoadBalancersPublisher resume(DescribeLoadBalancersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeLoadBalancersPublisher(this.client, (DescribeLoadBalancersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new DescribeLoadBalancersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeLoadBalancersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeLoadBalancersResponseFetcher
    implements AsyncPageFetcher<DescribeLoadBalancersResponse> {
        private DescribeLoadBalancersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLoadBalancersResponse previousPage) {
            return previousPage.nextMarker() != null;
        }

        public CompletableFuture<DescribeLoadBalancersResponse> nextPage(DescribeLoadBalancersResponse previousPage) {
            if (previousPage == null) {
                return DescribeLoadBalancersPublisher.this.client.describeLoadBalancers(DescribeLoadBalancersPublisher.this.firstRequest);
            }
            return DescribeLoadBalancersPublisher.this.client.describeLoadBalancers((DescribeLoadBalancersRequest)((Object)DescribeLoadBalancersPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

