/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TargetDescription
implements ToCopyableBuilder<Builder, TargetDescription> {
    private final String id;
    private final Integer port;
    private final String availabilityZone;

    private TargetDescription(BuilderImpl builder) {
        this.id = builder.id;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
    }

    public String id() {
        return this.id;
    }

    public Integer port() {
        return this.port;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetDescription)) {
            return false;
        }
        TargetDescription other = (TargetDescription)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.availabilityZone(), other.availabilityZone());
    }

    public String toString() {
        return ToString.builder((String)"TargetDescription").add("Id", (Object)this.id()).add("Port", (Object)this.port()).add("AvailabilityZone", (Object)this.availabilityZone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Integer port;
        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetDescription model) {
            this.id(model.id);
            this.port(model.port);
            this.availabilityZone(model.availabilityZone);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public TargetDescription build() {
            return new TargetDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetDescription> {
        public Builder id(String var1);

        public Builder port(Integer var1);

        public Builder availabilityZone(String var1);
    }
}

