/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupArnsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTargetGroupsRequest
extends ElasticLoadBalancingv2Request
implements ToCopyableBuilder<Builder, DescribeTargetGroupsRequest> {
    private final String loadBalancerArn;
    private final List<String> targetGroupArns;
    private final List<String> names;
    private final String marker;
    private final Integer pageSize;

    private DescribeTargetGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.targetGroupArns = builder.targetGroupArns;
        this.names = builder.names;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public List<String> targetGroupArns() {
        return this.targetGroupArns;
    }

    public List<String> names() {
        return this.names;
    }

    public String marker() {
        return this.marker;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.names());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetGroupsRequest)) {
            return false;
        }
        DescribeTargetGroupsRequest other = (DescribeTargetGroupsRequest)((Object)obj);
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.targetGroupArns(), other.targetGroupArns()) && Objects.equals(this.names(), other.names()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTargetGroupsRequest").add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("TargetGroupArns", this.targetGroupArns()).add("Names", this.names()).add("Marker", (Object)this.marker()).add("PageSize", (Object)this.pageSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.of(clazz.cast(this.loadBalancerArn()));
            }
            case "TargetGroupArns": {
                return Optional.of(clazz.cast(this.targetGroupArns()));
            }
            case "Names": {
                return Optional.of(clazz.cast(this.names()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "PageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Request.BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private List<String> targetGroupArns;
        private List<String> names;
        private String marker;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTargetGroupsRequest model) {
            this.loadBalancerArn(model.loadBalancerArn);
            this.targetGroupArns(model.targetGroupArns);
            this.names(model.names);
            this.marker(model.marker);
            this.pageSize(model.pageSize);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final Collection<String> getTargetGroupArns() {
            return this.targetGroupArns;
        }

        @Override
        public final Builder targetGroupArns(Collection<String> targetGroupArns) {
            this.targetGroupArns = TargetGroupArnsCopier.copy(targetGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupArns(String ... targetGroupArns) {
            this.targetGroupArns(Arrays.asList(targetGroupArns));
            return this;
        }

        public final void setTargetGroupArns(Collection<String> targetGroupArns) {
            this.targetGroupArns = TargetGroupArnsCopier.copy(targetGroupArns);
        }

        public final Collection<String> getNames() {
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = TargetGroupNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = TargetGroupNamesCopier.copy(names);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeTargetGroupsRequest build() {
            return new DescribeTargetGroupsRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Request.Builder,
    CopyableBuilder<Builder, DescribeTargetGroupsRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder targetGroupArns(Collection<String> var1);

        public Builder targetGroupArns(String ... var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder marker(String var1);

        public Builder pageSize(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

