/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingv2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup;

public final class DescribeTargetGroupsPaginator
implements SdkIterable<DescribeTargetGroupsResponse> {
    private final ElasticLoadBalancingv2Client client;
    private final DescribeTargetGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeTargetGroupsPaginator(ElasticLoadBalancingv2Client client, DescribeTargetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTargetGroupsResponseFetcher();
    }

    public Iterator<DescribeTargetGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<TargetGroup> targetGroups() {
        Function<DescribeTargetGroupsResponse, Iterator> getIterator = response -> response != null ? response.targetGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeTargetGroupsResponseFetcher
    implements NextPageFetcher<DescribeTargetGroupsResponse> {
        private DescribeTargetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTargetGroupsResponse previousPage) {
            return previousPage.nextMarker() != null;
        }

        public DescribeTargetGroupsResponse nextPage(DescribeTargetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTargetGroupsPaginator.this.client.describeTargetGroups(DescribeTargetGroupsPaginator.this.firstRequest);
            }
            return DescribeTargetGroupsPaginator.this.client.describeTargetGroups((DescribeTargetGroupsRequest)((Object)DescribeTargetGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

