/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetSecurityGroupsResponse
extends ElasticLoadBalancingv2Response
implements ToCopyableBuilder<Builder, SetSecurityGroupsResponse> {
    private final List<String> securityGroupIds;

    private SetSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.securityGroupIds = builder.securityGroupIds;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSecurityGroupsResponse)) {
            return false;
        }
        SetSecurityGroupsResponse other = (SetSecurityGroupsResponse)((Object)obj);
        return Objects.equals(this.securityGroupIds(), other.securityGroupIds());
    }

    public String toString() {
        return ToString.builder((String)"SetSecurityGroupsResponse").add("SecurityGroupIds", this.securityGroupIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Response.BuilderImpl
    implements Builder {
        private List<String> securityGroupIds;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSecurityGroupsResponse model) {
            this.securityGroupIds(model.securityGroupIds);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupsCopier.copy(securityGroupIds);
        }

        @Override
        public SetSecurityGroupsResponse build() {
            return new SetSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Response.Builder,
    CopyableBuilder<Builder, SetSecurityGroupsResponse> {
        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);
    }
}

