/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleConditionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Rule
implements ToCopyableBuilder<Builder, Rule> {
    private final String ruleArn;
    private final String priority;
    private final List<RuleCondition> conditions;
    private final List<Action> actions;
    private final Boolean isDefault;

    private Rule(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.priority = builder.priority;
        this.conditions = builder.conditions;
        this.actions = builder.actions;
        this.isDefault = builder.isDefault;
    }

    public String ruleArn() {
        return this.ruleArn;
    }

    public String priority() {
        return this.priority;
    }

    public List<RuleCondition> conditions() {
        return this.conditions;
    }

    public List<Action> actions() {
        return this.actions;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.ruleArn(), other.ruleArn()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.conditions(), other.conditions()) && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.isDefault(), other.isDefault());
    }

    public String toString() {
        return ToString.builder((String)"Rule").add("RuleArn", (Object)this.ruleArn()).add("Priority", (Object)this.priority()).add("Conditions", this.conditions()).add("Actions", this.actions()).add("IsDefault", (Object)this.isDefault()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleArn": {
                return Optional.of(clazz.cast(this.ruleArn()));
            }
            case "Priority": {
                return Optional.of(clazz.cast(this.priority()));
            }
            case "Conditions": {
                return Optional.of(clazz.cast(this.conditions()));
            }
            case "Actions": {
                return Optional.of(clazz.cast(this.actions()));
            }
            case "IsDefault": {
                return Optional.of(clazz.cast(this.isDefault()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleArn;
        private String priority;
        private List<RuleCondition> conditions;
        private List<Action> actions;
        private Boolean isDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.ruleArn(model.ruleArn);
            this.priority(model.priority);
            this.conditions(model.conditions);
            this.actions(model.actions);
            this.isDefault(model.isDefault);
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        public final String getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(String priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(String priority) {
            this.priority = priority;
        }

        public final Collection<RuleCondition.Builder> getConditions() {
            return this.conditions != null ? (Collection)this.conditions.stream().map(RuleCondition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conditions(Collection<RuleCondition> conditions) {
            this.conditions = RuleConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(RuleCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        public final void setConditions(Collection<RuleCondition.BuilderImpl> conditions) {
            this.conditions = RuleConditionListCopier.copyFromBuilder(conditions);
        }

        public final Collection<Action.Builder> getActions() {
            return this.actions != null ? (Collection)this.actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionsCopier.copyFromBuilder(actions);
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public Rule build() {
            return new Rule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Rule> {
        public Builder ruleArn(String var1);

        public Builder priority(String var1);

        public Builder conditions(Collection<RuleCondition> var1);

        public Builder conditions(RuleCondition ... var1);

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder isDefault(Boolean var1);
    }
}

