/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateTargetGroupRequest
extends ElasticLoadBalancingv2Request
implements ToCopyableBuilder<Builder, CreateTargetGroupRequest> {
    private final String name;
    private final String protocol;
    private final Integer port;
    private final String vpcId;
    private final String healthCheckProtocol;
    private final String healthCheckPort;
    private final String healthCheckPath;
    private final Integer healthCheckIntervalSeconds;
    private final Integer healthCheckTimeoutSeconds;
    private final Integer healthyThresholdCount;
    private final Integer unhealthyThresholdCount;
    private final Matcher matcher;
    private final String targetType;

    private CreateTargetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.vpcId = builder.vpcId;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckPath = builder.healthCheckPath;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
        this.healthyThresholdCount = builder.healthyThresholdCount;
        this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
        this.matcher = builder.matcher;
        this.targetType = builder.targetType;
    }

    public String name() {
        return this.name;
    }

    public ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(this.protocol);
    }

    public String protocolString() {
        return this.protocol;
    }

    public Integer port() {
        return this.port;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public ProtocolEnum healthCheckProtocol() {
        return ProtocolEnum.fromValue(this.healthCheckProtocol);
    }

    public String healthCheckProtocolString() {
        return this.healthCheckProtocol;
    }

    public String healthCheckPort() {
        return this.healthCheckPort;
    }

    public String healthCheckPath() {
        return this.healthCheckPath;
    }

    public Integer healthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds;
    }

    public Integer healthCheckTimeoutSeconds() {
        return this.healthCheckTimeoutSeconds;
    }

    public Integer healthyThresholdCount() {
        return this.healthyThresholdCount;
    }

    public Integer unhealthyThresholdCount() {
        return this.unhealthyThresholdCount;
    }

    public Matcher matcher() {
        return this.matcher;
    }

    public TargetTypeEnum targetType() {
        return TargetTypeEnum.fromValue(this.targetType);
    }

    public String targetTypeString() {
        return this.targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolString());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckProtocolString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.matcher());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTargetGroupRequest)) {
            return false;
        }
        CreateTargetGroupRequest other = (CreateTargetGroupRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.protocolString(), other.protocolString()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.healthCheckProtocolString(), other.healthCheckProtocolString()) && Objects.equals(this.healthCheckPort(), other.healthCheckPort()) && Objects.equals(this.healthCheckPath(), other.healthCheckPath()) && Objects.equals(this.healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds()) && Objects.equals(this.healthCheckTimeoutSeconds(), other.healthCheckTimeoutSeconds()) && Objects.equals(this.healthyThresholdCount(), other.healthyThresholdCount()) && Objects.equals(this.unhealthyThresholdCount(), other.unhealthyThresholdCount()) && Objects.equals(this.matcher(), other.matcher()) && Objects.equals(this.targetTypeString(), other.targetTypeString());
    }

    public String toString() {
        return ToString.builder((String)"CreateTargetGroupRequest").add("Name", (Object)this.name()).add("Protocol", (Object)this.protocolString()).add("Port", (Object)this.port()).add("VpcId", (Object)this.vpcId()).add("HealthCheckProtocol", (Object)this.healthCheckProtocolString()).add("HealthCheckPort", (Object)this.healthCheckPort()).add("HealthCheckPath", (Object)this.healthCheckPath()).add("HealthCheckIntervalSeconds", (Object)this.healthCheckIntervalSeconds()).add("HealthCheckTimeoutSeconds", (Object)this.healthCheckTimeoutSeconds()).add("HealthyThresholdCount", (Object)this.healthyThresholdCount()).add("UnhealthyThresholdCount", (Object)this.unhealthyThresholdCount()).add("Matcher", (Object)this.matcher()).add("TargetType", (Object)this.targetTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocolString()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "HealthCheckProtocol": {
                return Optional.of(clazz.cast(this.healthCheckProtocolString()));
            }
            case "HealthCheckPort": {
                return Optional.of(clazz.cast(this.healthCheckPort()));
            }
            case "HealthCheckPath": {
                return Optional.of(clazz.cast(this.healthCheckPath()));
            }
            case "HealthCheckIntervalSeconds": {
                return Optional.of(clazz.cast(this.healthCheckIntervalSeconds()));
            }
            case "HealthCheckTimeoutSeconds": {
                return Optional.of(clazz.cast(this.healthCheckTimeoutSeconds()));
            }
            case "HealthyThresholdCount": {
                return Optional.of(clazz.cast(this.healthyThresholdCount()));
            }
            case "UnhealthyThresholdCount": {
                return Optional.of(clazz.cast(this.unhealthyThresholdCount()));
            }
            case "Matcher": {
                return Optional.of(clazz.cast(this.matcher()));
            }
            case "TargetType": {
                return Optional.of(clazz.cast(this.targetTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Request.BuilderImpl
    implements Builder {
        private String name;
        private String protocol;
        private Integer port;
        private String vpcId;
        private String healthCheckProtocol;
        private String healthCheckPort;
        private String healthCheckPath;
        private Integer healthCheckIntervalSeconds;
        private Integer healthCheckTimeoutSeconds;
        private Integer healthyThresholdCount;
        private Integer unhealthyThresholdCount;
        private Matcher matcher;
        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTargetGroupRequest model) {
            this.name(model.name);
            this.protocol(model.protocol);
            this.port(model.port);
            this.vpcId(model.vpcId);
            this.healthCheckProtocol(model.healthCheckProtocol);
            this.healthCheckPort(model.healthCheckPort);
            this.healthCheckPath(model.healthCheckPath);
            this.healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            this.healthCheckTimeoutSeconds(model.healthCheckTimeoutSeconds);
            this.healthyThresholdCount(model.healthyThresholdCount);
            this.unhealthyThresholdCount(model.unhealthyThresholdCount);
            this.matcher(model.matcher);
            this.targetType(model.targetType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getHealthCheckProtocol() {
            return this.healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return this.healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getHealthCheckTimeoutSeconds() {
            return this.healthCheckTimeoutSeconds;
        }

        @Override
        public final Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public final void setHealthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
        }

        public final Integer getHealthyThresholdCount() {
            return this.healthyThresholdCount;
        }

        @Override
        public final Builder healthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public final void setHealthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
        }

        public final Integer getUnhealthyThresholdCount() {
            return this.unhealthyThresholdCount;
        }

        @Override
        public final Builder unhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public final void setUnhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        public final Matcher.Builder getMatcher() {
            return this.matcher != null ? this.matcher.toBuilder() : null;
        }

        @Override
        public final Builder matcher(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public final void setMatcher(Matcher.BuilderImpl matcher) {
            this.matcher = matcher != null ? matcher.build() : null;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetTypeEnum targetType) {
            this.targetType(targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateTargetGroupRequest build() {
            return new CreateTargetGroupRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Request.Builder,
    CopyableBuilder<Builder, CreateTargetGroupRequest> {
        public Builder name(String var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolEnum var1);

        public Builder port(Integer var1);

        public Builder vpcId(String var1);

        public Builder healthCheckProtocol(String var1);

        public Builder healthCheckProtocol(ProtocolEnum var1);

        public Builder healthCheckPort(String var1);

        public Builder healthCheckPath(String var1);

        public Builder healthCheckIntervalSeconds(Integer var1);

        public Builder healthCheckTimeoutSeconds(Integer var1);

        public Builder healthyThresholdCount(Integer var1);

        public Builder unhealthyThresholdCount(Integer var1);

        public Builder matcher(Matcher var1);

        default public Builder matcher(Consumer<Matcher.Builder> matcher) {
            return this.matcher((Matcher)((Matcher.Builder)Matcher.builder().apply(matcher)).build());
        }

        public Builder targetType(String var1);

        public Builder targetType(TargetTypeEnum var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

